;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Cnst/walk.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Mar 25 16:26:07 1993                          */
;*    Last change :  Wed Dec  1 13:39:58 1993 (serrano)                */
;*                                                                     */
;*    L'allocation des constantes.                                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_walk
   (include "Var/variable.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    cnst_expression
	    cnst_read_expression
	    cnst_alloc
	    cnst_read_alloc
	    cnst_init
	    cnst_read_init
	    cnst_module
	    var_env
	    engine_param)
   (export  (cnst-walk tree)))

;*---------------------------------------------------------------------*/
;*    cnst-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (cnst-walk tree) 
   (verbose "   . Cnst" #\Newline)
   (start-partial-error "Cnst")
   (if *lib-mode*
       (begin
	  (init-cnst-alloc)
	  (init-cnst-module))
       (begin
	  (init-cnst-module)
	  (init-cnst-read-alloc)))
   (let ((module-init (find-in-global-environment (initialisation-name)
						  *Genv*)))
      (let loop ((walk      tree)
		 (init-form #f))
	 (if (null? walk)
	     (begin
		(fail-if-partial-error)
		(if *lib-mode*
		    (cnst-init-module! init-form)
		    (cnst-init-read-module! init-form))
		tree)
	     (let ((var (car walk)))
		(let (body value)
		   (enter-function (shape var))
		   (cond
		      ((global? var)
		       (global-info-set! var 'used)
		       (set! value (global-value var))
		       (set! body (function-body value))
		       (if *lib-mode*
			   (function-body-set! value (cnst body #f))
			   (function-body-set! value (read-cnst body #f))))
		      ((local? var)
		       (set! value (local-value var))
		       (if (eq? (local-class var) 'function)
			   (begin
			      (set! body (function-body value))
			      (if *lib-mode*
				  (function-body-set! value
						      (cnst body #f))
				  (function-body-set! value
						      (read-cnst body #f))))
			   (begin
			      (set! body (return-body value))
			      (if *lib-mode*
				  (return-body-set! value
						    (cnst body #f))
				  (return-body-set! value
						    (read-cnst body #f)))))))
		   (leave-function)
		   (if (eq? var module-init)
		       (loop (cdr walk)
			     (car walk))
		       (loop (cdr walk)
			     init-form))))))))

