;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../read-alloc.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  1 17:56:40 1993                          */
;*    Last change :  Wed Nov  2 15:19:41 1994 (serrano)                */
;*                                                                     */
;*    Le module ou on fait les pre-allocations                         */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_read_alloc
   (include "Var/variable.sch"
	    "Tools/trace.sch")
   (import  engine_param
	    tools_hash
	    tools_shape
	    tools_strings
	    tools_file
	    var_declare
	    scan_lexical
	    heap_abstract
	    cnst_module)
   (export  (init-cnst-read-alloc)
	    (read-cnst-alloc-string string)
	    (read-cnst-alloc-real   real)
	    (read-cnst-alloc-symbol symbol)
	    (read-cnst-alloc-list   list)
	    (read-cnst-alloc-vector vector)
	    (read-cnst-alloc-procedure  procedure link?)
	    (read-procedure-initialisation)
	    (read-cnst-initialisation)))

;*---------------------------------------------------------------------*/
;*    Les structures                                                   */
;*---------------------------------------------------------------------*/
(define-struct cnst-info      cnst      offset)
(define-struct procedure-info proc      variable)

;*---------------------------------------------------------------------*/
;*    Le vecteur et l'offset pour memoriser toutes les constantes      */
;*---------------------------------------------------------------------*/
(define *cnst-table*  (unspecified))
(define *cnst-offset* (unspecified))

;*---------------------------------------------------------------------*/
;*    cnst-info-create ...                                             */
;*---------------------------------------------------------------------*/
(define (cnst-info-create cnst)
   (let ((new (make-cnst-info)))
      (cnst-info-cnst-set! new cnst)
      new))

;*---------------------------------------------------------------------*/
;*    procedure-info-create ...                                        */
;*---------------------------------------------------------------------*/
(define (procedure-info-create procedure)
   (let ((new (make-procedure-info)))
      (procedure-info-proc-set! new procedure)
      new))

;*---------------------------------------------------------------------*/
;*    Le tables pour le hashage                                        */
;*---------------------------------------------------------------------*/
(define *string-env*    '())
(define *real-env*      '())
(define *symbol-env*    '())
(define *list-env*      '())
(define *vector-env*    '())
(define *procedure-env* '())
(define *global-env*    '())

;*---------------------------------------------------------------------*/
;*    init-cnst-read-alloc ...                                         */
;*---------------------------------------------------------------------*/
(define (init-cnst-read-alloc)
   (set! *cnst-table* (declare-global-variable! "__CNSTS_TABLE"
						*module-name*
						'special))
   (set! *cnst-offset* 0)
   (set! *string-env* (make-hashtable 'string-env
				       'string
				       cnst-info-create
				       cnst-info-cnst
				       (lambda (l) l)))
   (set! *real-env*   (make-hashtable 'real-env
				       'string
				       cnst-info-create
				       cnst-info-cnst
				       (lambda (l) l)))
   (set! *symbol-env* (make-hashtable 'symbol-env
				       'symbol
				       cnst-info-create
				       cnst-info-cnst
				       (lambda (l) l))))

;*---------------------------------------------------------------------*/
;*    get-variable-name ...                                            */
;*---------------------------------------------------------------------*/
(define get-variable-name 
   (let ((key -1))
      (lambda (class)
	 (set! key (+fx 1 key))
	 (upper-string->symbol (string-append class
					      "_"
					      (integer->string key))))))
				       
;*---------------------------------------------------------------------*/
;*    read-cnst-alloc-string ...                                       */
;*    string x { t, f } --> global                                     */
;*    -------------------------------------------------------------    */
;*    Les strings sont un peu particulieres car elles sont allouees    */
;*    statiquement, on ne les rangent donc pas toutes dans un tableau. */
;*---------------------------------------------------------------------*/
(define (read-cnst-alloc-string string)
   (let ((old (and *shared-data*
		   (find-object string *string-env* 'string-env))))
      (if old
	  (abstract 'cnst-table-ref (cnst-info-offset old))
	  (let ((new (bind-object! string *string-env* 'string-env)))
	     (cnst-info-offset-set! new *cnst-offset*)
	     (set! *cnst-offset* (+fx 1 *cnst-offset*))
	     (set! *global-env* (cons string *global-env*))
	     (abstract 'cnst-table-ref (cnst-info-offset new))))))

;*---------------------------------------------------------------------*/
;*    read-cnst-alloc-real ...                                         */
;*    real x { t, f } --> global                                       */
;*    -------------------------------------------------------------    */
;*    Les reals sont un peu particulieres car elles sont allouees      */
;*    statiquement, on ne les rangent donc pas toutes dans un tableau. */
;*---------------------------------------------------------------------*/
(define (read-cnst-alloc-real real)
   (let* ((string (real->string real))
	  (old (and *shared-data*
		   (find-object string *real-env* 'real-env))))
      (if old
	  (abstract 'cnst-table-ref (cnst-info-offset old))
	  (let ((new (bind-object! string *real-env* 'real-env)))
	     (cnst-info-offset-set! new *cnst-offset*)
	     (set! *cnst-offset* (+fx 1 *cnst-offset*))
	     (set! *global-env* (cons real *global-env*))
	     (abstract 'cnst-table-ref (cnst-info-offset new))))))

;;*---------------------------------------------------------------------*/
;*    read-cnst-alloc-symbol ...                                       */
;*    symbol --> global                                                */
;*---------------------------------------------------------------------*/
(define (read-cnst-alloc-symbol symbol)
   (let ((old (find-object symbol *symbol-env* 'symbol-env)))
      (if old
	  (abstract 'cnst-table-ref (cnst-info-offset old))
	  (let ((new (bind-object! symbol *symbol-env* 'symbol-env)))
	     (cnst-info-offset-set! new *cnst-offset*)
	     (set! *cnst-offset* (+fx 1 *cnst-offset*))
	     (set! *global-env* (cons symbol *global-env*))
	     (abstract 'cnst-table-ref (cnst-info-offset new))))))

;*---------------------------------------------------------------------*/
;*    read-cnst-alloc-list ...                                         */
;*---------------------------------------------------------------------*/
(define (read-cnst-alloc-list list)
   (let ((old (and *shared-data*
		   (let loop ((env *list-env*))
		      (cond
			 ((null? env)
			  #f)
			 ((equal? (cnst-info-cnst (car env)) list)
			  (car env))
			 (else
			  (loop (cdr env))))))))
      (if old
	  (abstract 'cnst-table-ref (cnst-info-offset old))
	  (let ((new (cnst-info-create list)))
	     (if *shared-data*
		 (set! *list-env* (cons new *list-env*)))
	     (cnst-info-offset-set! new *cnst-offset*)
	     (set! *cnst-offset* (+fx *cnst-offset* 1))
	     (set! *global-env* (cons list *global-env*))
	     (abstract 'cnst-table-ref (cnst-info-offset new))))))

;*---------------------------------------------------------------------*/
;*    read-cnst-alloc-vector ...                                       */
;*---------------------------------------------------------------------*/
(define (read-cnst-alloc-vector vector)
   (let ((old (and *shared-data*
		   (let loop ((env *vector-env*))
		      (cond
			 ((null? env)
			  #f)
			 ((equal? (cnst-info-cnst (car env)) vector)
			  (car env))
			 (else
			  (loop (cdr env))))))))
      (if old
	  (abstract 'cnst-table-ref (cnst-info-offset old))
	  (let ((new (cnst-info-create vector)))
	     (if *shared-data*
		 (set! *vector-env* (cons new *vector-env*)))
	     (cnst-info-offset-set! new *cnst-offset*)
	     (set! *cnst-offset* (+fx *cnst-offset* 1))
	     (set! *global-env* (cons vector *global-env*))
	     (abstract 'cnst-table-ref (cnst-info-offset new))))))

;*---------------------------------------------------------------------*/
;*    read-cnst-alloc-procedure ...                                    */
;*---------------------------------------------------------------------*/
(define (read-cnst-alloc-procedure procedure link?)
   (if link?
       procedure
       (let* ((new (procedure-info-create procedure))
	      (var (declare-global-variable! (get-variable-name "procedure")
					     *module-name*
					     'static)))
	  (procedure-info-variable-set! new var)
	  (set! *procedure-env* (cons new *procedure-env*))
	  var))) 
  
;*---------------------------------------------------------------------*/
;*    read-procedure-initialisation ...                                */
;*---------------------------------------------------------------------*/
(define (read-procedure-initialisation)
   (map (lambda (pi)
	   `(set! ,(procedure-info-variable pi)
		  ,(procedure-info-proc pi)))
	*procedure-env*))

;*---------------------------------------------------------------------*/
;*    read-cnst-initialisation ...                                     */
;*---------------------------------------------------------------------*/
(define (read-cnst-initialisation)
   (if (null? *global-env*)
       '()
       (let* ((cnsts-string (make-cnst-string))
	      (the-port     (allocate-local-variable 'port))
	      (the-offset   (allocate-local-variable 'offset))
	      (the-function (cdar (allocate-local-functions '(loop))))
	      (body         `(cif ,(abstract 'c-lt.i
					     the-offset
					     (abstract 'c-cint->bint 0))
				  ,(abstract-unspecified)
				  (begin
				     ,(abstract 'cnst-table-set!
						the-offset
						`(funcall
						  ,(car (abstract 'read))
						  ,(car (abstract 'read))
						  ,the-port
						  ,(abstract-eoa)))
				     (,the-function ,(abstract 'c-sub.i
							       the-offset
							       (abstract
								'c-cint->bint
								1)))))))
	  (function-arity-set! (local-value the-function) 1)
	  (function-args-set!  (local-value the-function) (list the-offset))
	  (function-body-set!  (local-value the-function) body)
	  ;; Le tableau statique a deja ete declare. Maintenant qu'on
	  ;; connait sa taille on peut y aller du gros hack qui
	  ;; consiste a glisser sa taille dans son nom
	  (global-c-name-set! *cnst-table*
			      (string-append "__cnst[ "
					     (number->string *cnst-offset*)
					     " ] "))
;*---------------------------------------------------------------------*/
;*    Ceci marche car on n'initialise les modules que plus tard (voir  */
;*    remarque dans le fichier `Cnst/init.scm').                       */
;*---------------------------------------------------------------------*/
	  (remember-module! (global-module (car (abstract 'read))))
	  (list
	   (abstract 'declare-cnst-table *cnst-table*)
	   `(let ((,the-port ,(abstract 'open-input-string
					(abstract 'c-constant-string-to-string
						  cnsts-string))))
	       (labels ((,the-function (,the-offset) ,body))
		  (,the-function ,(abstract 'c-cint->bint
					    (-fx *cnst-offset* 1)))))))))

;*---------------------------------------------------------------------*/
;*    make-cnst-string ...                                             */
;*---------------------------------------------------------------------*/
(define (make-cnst-string)
   (let* ((port (open-output-string)))
      (if (not (output-port? port))
	  (error "make-cnst-string"
		 "Can't open output string port"
		 port)
	  (begin
	     (for-each (lambda (cnst)
			  (write-cnst cnst port)
			  (write-char #\space port))
		       *global-env*)
	     (close-output-port port)))))
  
;*---------------------------------------------------------------------*/
;*    write-cnst ...                                                   */
;*---------------------------------------------------------------------*/
(define (write-cnst cnst port)
   (cond
      ((vector? cnst)
       (write-char #\# port)
       (let ((tag (vector-tag cnst)))
	  (if (>fx tag 0)
	      (begin
		 (if (>=fx tag 100)
		     (write tag port)
		     (begin
			(write-char #\0 port)
			(if (>=fx tag 10)
			    (write tag port)
			    (begin
			       (write-char #\0 port)
			       (write tag port))))))))
       (write-char #\( port)
       (let ((len (vector-length cnst)))
	  (let loop ((i 0))
	     (if (=fx i len)
		 (write-char #\) port)
		 (begin
		    (write-cnst (vector-ref cnst i) port)
		    (write-char #\space port)
		    (loop (+fx i 1)))))))
      ((string? cnst)
       (write-char #\# port)
       (write-c-string port cnst))
      ((not (pair? cnst))
       (write cnst port))
      (else
       (write-char #\( port)
       (let loop ((cnst cnst))
	  (cond
	     ((null? cnst)
	      (write-char #\) port))
	     ((not (pair? cnst))
	      (display ". " port)
	      (write-cnst cnst port)
	      (write-char #\) port))
	     (else
	      (write-cnst (car cnst) port)
	      (write-char #\space port)
	      (loop (cdr cnst))))))))


	   
	 
		 
    




