;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    .../expression.scm ...                                           */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Apr  1 14:18:09 1993                          */
;*    Last change :  Thu Dec 22 08:01:11 1994 (serrano)                */
;*                                                                     */
;*    L'allocation des constantes                                      */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cnst_expression
   (include "Tools/trace.sch"
	    "Var/variable.sch")
   (import  heap_abstract
	    engine_param
	    cnst_alloc
	    cnst_module
	    tools_shape
	    tools_speek
	    tools_error)
   (export  (cnst exp link?)))

;*---------------------------------------------------------------------*/
;*    cnst ...                                                         */
;*---------------------------------------------------------------------*/
(define (cnst exp link?)
   (trace cnst "exp: " (shape exp) #\Newline)
   (match-case exp
;*--- nil -------------------------------------------------------------*/
      (()
       exp)
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (if (global? exp)
	   (if (not (eq? (global-class exp) 'foreign))
	       (remember-module! (global-module exp))))
       exp)
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (set-car! (cddr exp) (cnst (caddr exp) #t))
       exp)
;*--- function --------------------------------------------------------*/
      (((or function function-light) ?var)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       (cnst-quote (cadr exp)))
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- cast ------------------------------------------------------------*/
      ((cast ?- ?rest)
       (set-car! (cddr exp) (cnst rest link?))
       exp)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (set-car! (cdr exp) (cnst (cadr exp) #f))
       (set-car! (cddr exp) (cnst (caddr exp) #f))
       (set-car! (cdddr exp) (cnst (cadddr exp) #f))
       exp)
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (set-car! (cdr exp) (cnst (cadr exp) #f))
       (if (boolean? (cadr exp))
	   (if (cadr exp)
	       (cnst (caddr exp) link?)
	       (cnst (cadddr exp) link?))
	   (begin
	      (set-car! (cddr exp) (cnst (caddr exp) link?))
	      (set-car! (cdddr exp) (cnst (cadddr exp) link?))
	      exp)))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?- ?test . ?clauses)
       (set-car! (cddr exp) (cnst test #f))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdr (car hook))
			   (cnst (cadr (car hook)) link?))
		 (loop (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? (cdr hook))
	      (begin
		 (set-car! hook (cnst (car hook) link?))
		 exp)
	      (begin
		 (set-car! hook (cnst (car hook) #f))
		 (loop (cdr hook))))))
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (let loop ((hook (cadr exp)))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (cnst (caddr exp) link?))
		 exp)
	      (begin
		 (set-car! (cdar hook)
			   (cnst (cadr (car hook)) #f))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels . ?-)
       (let loop ((hook (cadr exp)))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (cnst (caddr exp) link?))
		 exp)
	      (begin
		 (set-car! (cddar hook)
			   (cnst (caddr (car hook)) #f))
		 (function-body-set! (local-value (car (car hook)))
				     (caddar hook))
		 (loop (cdr hook))))))
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (set-car! (cddr exp) (cnst (caddr exp) #f))
       exp)
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (set-car! (cddr exp) (cnst (caddr exp) #f))
       exp)
;*--- apply -----------------------------------------------------------*/
      ((apply . ?-)
       (let liip ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (cnst (car hook) #f))
		 (liip (cdr hook))))))
;*--- funcall ---------------------------------------------------------*/
      (((or funcall funcall-light) . ?-)
       (let liip ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (cnst (car hook) #f))
		 (liip (cdr hook))))))
;*--- application -----------------------------------------------------*/
      (else
       (cnst-application exp link?))))

;*---------------------------------------------------------------------*/
;*    cnst-quote ...                                                   */
;*---------------------------------------------------------------------*/
(define (cnst-quote exp)
   (trace cnst "cnst-quote: " (shape exp) #\Newline)
   (cond
      ((null? exp)
       (abstract-nil))
      ((symbol? exp)
       (cnst-alloc-symbol exp))
      ((string? exp)
       (cnst-alloc-string exp))
      ((char? exp)
       (abstract-cchar->bchar exp))
      ((boolean? exp)
       (abstract-cbool->bbool exp))
      ((eq? exp #unspecified)
       (abstract-unspecified))
      ((integer? exp)
       (abstract-cint->bint exp))
      ((real? exp)
       (abstract-cdouble->breal exp))
      ((pair? exp)
       (cnst-list exp))
      ((vector? exp)
       (cnst-vector exp))
      ((cnst? exp)
       (abstract 'make-cnst (cnst->integer exp)))
      (else
       (error "cnst-quote" "Illegal expression" (shape exp)))))

;*---------------------------------------------------------------------*/
;*    cnst-list ...                                                    */
;*---------------------------------------------------------------------*/
(define (cnst-list list)
   (let ((l (let loop ((pair list))
	       (cond
		  ((null? pair)
		   (abstract-nil))
		  ((not (pair? pair))
		   (cnst-quote pair))
		  (else
		   (abstract-cons (cnst-quote (car pair))
				  (loop (cdr pair))))))))
      (cnst-alloc-list l)))

;*---------------------------------------------------------------------*/
;*    cnst-vector ...                                                  */
;*---------------------------------------------------------------------*/
(define (cnst-vector vector)
   (abstract-list->vector (cnst-quote (vector->list vector))))

;*---------------------------------------------------------------------*/
;*    cnst-application ...                                             */
;*---------------------------------------------------------------------*/
(define (cnst-application exp link?)
   ;; on cnst tous les arguments
   (let liip ((hook exp))
	     (if (null? hook)
		 exp
		 (begin
		    (set-car! hook (cnst (car hook) #f))
		    (liip (cdr hook)))))
   ;; on reconnait les cas triviaux.
   (let ((fun (car exp)))
      (cond
	 ((and (abstract-cstring->bstring? fun)
	       (string? (cadr exp)))
	  (cnst-alloc-string (cadr exp)))
	 ((and (abstract-csymbol->bsymbol? fun)
	       (symbol? (cadr exp)))
	  (cnst-alloc-symbol (cadr exp)))
	 ((and (abstract-cbool->bbool? fun)
	       (boolean? (cadr exp)))
	  (if (cadr exp)
	      (abstract-true)
	      (abstract-false)))
	 ((and (or (abstract-make-fx-procedure? fun)
		   (abstract-make-va-procedure? fun))
	       (=fx (cadddr exp) 0))
	  (cnst-alloc-procedure exp link?))
	 ((and (abstract-make-light-procedure? fun)
	       (=fx (caddr exp) 0))
	  (cnst-alloc-procedure exp link?))
	 ((and (abstract? fun 'c-cdouble->breal)
	       (real? (cadr exp)))
	  (cnst-alloc-real (cadr exp)))
	 ((and (abstract-bbool->cbool? fun)
	       (pair? (cadr exp))
	       (abstract-cbool->bbool? (car (cadr exp))))
	  (cnst (cadr (cadr exp)) #f))
	 ((abstract-bbool->cbool? fun)
	  (cond
	     ((abstract-true? (cadr exp))
	      #t)
	     ((abstract-false? (cadr exp))
	      #f)
	     (else
	      exp)))
	 ((and (abstract-cbool->bbool? fun)
	       (pair? (cadr exp))
	       (abstract-bbool->cbool? (car (cadr exp))))
	  (cnst (cadr (cadr exp)) #f))
	 ((and (abstract-not? fun)
	       (pair? (cadr exp))
	       (abstract-not? (car (cadr exp))))
	  (cnst (cadr (cadr exp)) #f))
	 ((and (abstract-cint->bint? fun)
	       (pair? (cadr exp))
	       (abstract-bint->cint? (car (cadr exp))))
	  (cnst (cadr (cadr exp)) #f))
	 ((and (abstract-bint->cint? fun)
	       (pair? (cadr exp))
	       (abstract-cint->bint? (car (cadr exp))))
	  (cnst (cadr (cadr exp)) #f))
	 ((and (abstract? fun 'c-cchar->bchar)
	       (pair? (cadr exp))
	       (abstract? (car (cadr exp)) 'c-bchar->cchar))
	  (cnst (cadr (cadr exp)) #f))
	 ((and (abstract? fun 'c-bchar->cchar)
	       (pair? (cadr exp))
	       (abstract? (car (cadr exp)) 'c-cchar->bchar))
	  (cnst (cadr (cadr exp)) #f))
	 (else
	  exp))))

;*---------------------------------------------------------------------*/
;*    failure? ...                                                     */
;*---------------------------------------------------------------------*/
(define (failure? exp)
   (match-case exp
      ((failure ?- ?- ?-)
       #t)
      (else
       #f)))
