;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.5/Cgen/main.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Apr  4 10:33:41 1993                          */
;*    Last change :  Wed Sep  8 15:17:29 1993 (serrano)                */
;*                                                                     */
;*    On genere une fonction `main'                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cgen_main
   (include "Var/variable.sch")
   (import  engine_param
	    scan_lexical
	    var_declare
	    var_env
	    tools_strings)
   (export  (make-bigloo-main)))

;*---------------------------------------------------------------------*/
;*    make-bigloo-main ...                                             */
;*---------------------------------------------------------------------*/
(define (make-bigloo-main)
   (let* ((bigloo-main (declare-global-procedure! "bigloo_main"
						  '(argv)
						  *module-name*
						  'export))
	  (argv        (cdar (allocate-local-variables '(argv))))
	  (init        (find-in-global-environment (initialisation-name)
						   *Genv*))
	  (user-main   (cond
			  ((string? *main*)
			   (find-in-global-environment
			    (upper-string->symbol *main*)
			    *Genv*))
			  ((symbol? *main*)
			   (find-in-global-environment *main* *Genv*))
			  (else
			   #f)))
	  (main-body   `(begin
			   (,init)
			   ,(if (global? user-main)
				`(,user-main ,argv)))))
      (function-body-set! (global-value bigloo-main) main-body)
      (function-args-set! (global-value bigloo-main) (list argv))
      bigloo-main))

   
