;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/comptime1.6/Cc/ld.scm ...            */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul 17 09:37:55 1992                          */
;*    Last change :  Sat Jan 15 11:22:04 1994 (serrano)                */
;*                                                                     */
;*    Ok, il ne reste plus qu'a linker. On s`en occupe.                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module cc_ld
   (include "Tools/trace.sch")
   (export  (ld name))
   (import  tools_speek
	    engine_param))

;*---------------------------------------------------------------------*/
;*    list-of-string->string ...                                       */
;*---------------------------------------------------------------------*/
(define (list-of-string->string l)
   (let loop ((l (reverse l))
	      (r ""))
      (if (null? l)
	  r
	  (loop (cdr l)
		(string-append (car l) " " r)))))

;*---------------------------------------------------------------------*/
;*    ld ...                                                           */
;*    -------------------------------------------------------------    */
;*    Le link se fait avec plusieurs fichiers:                         */
;*       1- Le fichier .o resultat de la compilation courrante         */
;*       2- Tous les .o qui ont ete passes en argument                 */
;*       3- Tous les .o qui correspondent aux fichiers de presents     */
;*          dans les clauses `with' du main.                           */
;*---------------------------------------------------------------------*/
(define (ld name)
   (verbose "   . ld (" *cc* ")" #\Newline)
   (let ((dest (if (string? *dest*)
		   *dest*
		   "a.out")))
      (let* ((libs    (let loop ((lib (append *bigloo-lib* *bigloo-user-lib*))
				 (res ""))
			 (if (null? lib)
			     res
			     (loop (cdr lib)
				   (string-append (car lib) " " res)))))
	     (ld-args (string-append name ".o";; le nom du .o main
				     " "
				     (list-of-string->string *with-files*)
				     (list-of-string->string *o-files*)
				     " -o " dest;; le nom de l'exec
				     " "  *cc-options*;; les options de cc
				     " -L" *lib-dir*;; les paths
				     (if *c-debug*;; le debug
					 (string-append " " *c-debug-option*)
					 "")
				     (if *strip*;; strip l'executable ?
					 " -s"
					 "")
				     " " *ld-options*;; les options de ld
				     libs)))
	 (trace other "Je vais executer la commande: " #\Newline
		(string-append *cc* " " ld-args))
	 (let ((res (system (string-append *cc* " " ld-args))))
	    (if  (not (=fx res 0))
		 (error "ld" "cc problem" res))))))
	       
	      

