;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Beta/beta.scm ...        */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Apr 11 10:08:52 1993                          */
;*    Last change :  Thu Sep 29 10:17:41 1994 (serrano)                */
;*                                                                     */
;*    LA beta-reduction                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module beta_beta
   (include "Var/variable.sch"
	    "Tools/trace.sch"
	    "Beta/beta.sch")
   (import  tools_speek
	    tools_error
	    tools_shape
	    beta_walk
	    heap_abstract
	    effect_property)
   (export  (beta exp)))

;*---------------------------------------------------------------------*/
;*    beta ...                                                         */
;*---------------------------------------------------------------------*/
(define (beta exp)
   (trace beta "beta: " (shape exp) #\newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       (trace beta "atom: " (shape exp) #\Newline)
       (if (and (local? exp)
		(var? (local-info exp))
		(not (null? (var-substitute (local-info exp)))))
	   (var-substitute (local-info exp))
	   exp))
;*--- function --------------------------------------------------------*/
      (((or function function-extra-light function-light) ?-)
       (set-car! (cdr exp) (beta (cadr exp)))
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((cast ?- ?rest)
       (set-car! (cddr exp) (beta rest))
       exp)
;*--- failure ---------------------------------------------------------*/
      ((failure . ?-)
       (set-car! (cdr exp) (beta (cadr exp)))
       (set-car! (cddr exp) (beta (caddr exp)))
       (set-car! (cdddr exp) (beta (cadddr exp)))
       exp)
;*--- cif -------------------------------------------------------------*/
      ((cif . ?-)
       (set-car! (cdr exp) (beta (cadr exp)))
       (cond
	  ((boolean? (cadr exp))
	   (if (cadr exp)
	       (beta (caddr exp))
	       (beta (cadddr exp))))
	  ((and (pair? (cadr exp))
		(abstract-=fx? (car (cadr exp)))
		(pair? (cadr (cadr exp)))
		(pair? (cdr (cadr (cadr exp))))
		(pair? (caddr (cadr exp)))
		(pair? (cdr (caddr (cadr exp))))
		(abstract-cint->bint? (car (cadr (cadr exp))))
		(abstract-cint->bint? (car (caddr (cadr exp))))
		(integer? (cadr (cadr (cadr exp))))
		(integer? (cadr (caddr (cadr exp)))))
	   (if (=fx (cadr (cadr (cadr exp))) (cadr (caddr (cadr exp))))
	       (beta (caddr exp))
	       (beta (cadddr exp))))
	  (else
	   (set-car! (cddr exp) (beta (caddr exp)))
	   (set-car! (cdddr exp) (beta (cadddr exp)))
	   exp)))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (beta test))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdar hook) (beta (cadr (car hook))))
		 (loop (cdr hook))))))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (beta (car hook)))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! . ?-)
       (set-car! (cddr exp) (beta (caddr exp)))
       exp)
;*--- let (simple) ----------------------------------------------------*/
      ((let ((?var ?val)) (or ?var (begin ?var)))
       ;; ce cas correspond a un let dont on retourne tout de suite
       ;; la variable. J'ai rajoute cette petite regle pour ne pas
       ;; compliquer l'analyse dans `beta-let'.
       (let ((new-val (beta val)))
	  (var-substitute-set! (local-info var) new-val)
	  (var-always-set!     (local-info var) '())
	  new-val))
;*--- let -------------------------------------------------------------*/
      ((let . ?-)
       (beta-let exp))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (for-each (lambda (b)
		    (local-info-set! (car b) '())
		    (for-each (lambda (f)
				 (local-info-set! f '()))
			      (cadr b)))
		 bindings)
       (set-car! (cddr exp) (beta (caddr exp)))
       (let loop ((hook bindings))
	  (if (null? hook)
	      exp
	      (let ((binding (car hook)))
		 (set-car! (cddr binding) (beta (caddr binding)))
		 (function-body-set! (local-value (car binding))
				     (caddr binding))
		 (loop (cdr hook))))))
;*--- block -----------------------------------------------------------*/
      ((block . ?-)
       (set-car! (cddr exp) (beta (caddr exp)))
       exp)
;*--- return-from -----------------------------------------------------*/
      ((return-from . ?-)
       (set-car! (cddr exp) (beta (caddr exp)))
       exp)
;*--- funcall-extra-light ---------------------------------------------*/
      (((or apply
	    funcall
	    funcall-light
	    funcall-medium
	    (funcall-extra-light . ?-)) . ?-)
       (let loop ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (beta (car hook)))
		 (loop (cdr hook))))))
;*--- application -----------------------------------------------------*/
      (else
       (beta-application exp))))
       
;*---------------------------------------------------------------------*/
;*    beta-application ...                                             */
;*    -------------------------------------------------------------    */
;*    Si l'application satisfait les conditions suivantes:             */
;*       - C'est une fonction a 1 argument                             */
;*       - cet argument est une variable locale                        */
;*       - La fonction est egal au slot `always' de l'info de la locale*/
;*    Alors, on subsitue l'appel par l'argument car l'application aura */
;*    ete remontee dans la liaison de la variable.                     */
;*---------------------------------------------------------------------*/
(define (beta-application exp)
   (if (and (pair?  (cdr exp))
	    (local? (cadr exp))
	    (null?  (cddr exp))
	    (var?   (local-info (cadr exp)))
	    (not    (eq? (local-access (cadr exp)) 'write))
	    (eq?    (car exp) (var-always (local-info (cadr exp)))))
       (var-new-always (local-info (cadr exp)))
       (let loop ((hook exp))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (beta (car hook)))
		 (loop (cdr hook)))))))
  
;*---------------------------------------------------------------------*/
;*    beta-let ...                                                     */
;*    -------------------------------------------------------------    */
;*    Il faut vraiment etre tres `petit bras' quand on fait de la beta */
;*    reduction. En particulier, il ne faut pas oublier les cas comme: */
;*       (let ((x (car y)))                                            */
;*          (set-car! y 6)                                             */
;*          x)                                                         */
;*    Ou il ne faut surtout pas toucher a la liaison.                  */
;*    Le benchmark `destru' est un bon test pour ce genre de chose.    */
;*---------------------------------------------------------------------*/
(define (beta-let exp)
   (trace beta "beta-let: " (shape exp) #\Newline)
   (let loop ((bindings (cadr exp))
	      (tail     '()))
      (cond
	 ((null? bindings)
	  (if (null? tail)
	      (beta (caddr exp))
	      (begin
		 (set-car! (cddr exp) (beta (caddr exp)))
		 exp)))
	 (else
	  (let* ((binding (car bindings))
		 (var     (car binding)))
	     (trace beta "binding : " (shape binding) #\Newline
		         "      nb: " (var-nb (local-info (car binding)))
			 #\Newline
			 "     si?: " (not (side-effect? (cadr binding)))
			 #\Newline
			 "       a: " (shape (var-always (local-info var)))
			 "mutable?: " (shape (mutable? (cadr binding)))
			 #\Newline)
	     (set-car! (cdr binding) (beta (cadr binding)))
	     (cond
		((eq? (local-access var) 'write)
		 (loop (cdr bindings) bindings))
		((and (=fx (var-nb (local-info var)) 1)
		      (not (side-effect? (cadr binding)))
		      (or (not (side-effect-in-current-function?))
			  (not (mutable? (cadr binding)))))
		 (var-always-set!     (local-info var) '())
		 (var-substitute-set! (local-info var) (cadr binding))
		 ;; on coupe la branche de la liaison
		 (cond
		    ((null? tail)
		     (if (null? (cdr bindings))
			 ;; aucune liaison ne reste
			 (loop '() '())
			 (begin
			    (set-car! (cdr exp) (cdr (cadr exp)))
			    (loop (cdr bindings) '()))))
		    (else
		     (set-cdr! tail (cdr bindings))
		     (loop (cdr bindings) tail))))
		((and (not (side-effect? (cadr binding)))
		      (or (not (side-effect-in-current-function?))
			  (not (mutable? (cadr binding))))
		      (abstract-special-no-cost? (cadr binding)))
		 ;; s'il n'y a pas d'effet de bord que la variable est
		 ;; utilisee a plusieurs endroits mais que l'application
		 ;; ne coute rien, on inline.
		 (var-always-set!     (local-info var) '())
		 (var-substitute-set! (local-info var) (cadr binding))
		 ;; on coupe la branche de la liaison
		 (cond
		    ((null? tail)
		     (if (null? (cdr bindings))
			 ;; aucune liaison ne reste
			 (loop '() '())
			 (begin
			    (set-car! (cdr exp) (cdr (cadr exp)))
			    (loop (cdr bindings) '()))))
		    (else
		     (set-cdr! tail (cdr bindings))
		     (loop (cdr bindings) tail))))
		((and (var-always (local-info var))
		      (not (null? (var-always (local-info var)))))
		 ;; on remonte le test toujours effectue sur une variable
		 ;; la ou elle est definie
		 (set-car! binding (var-new-always (local-info var)))
		 (set-car! (cdr binding) (cons (var-always (local-info var))
					       (cons (cadr binding)
						     '())))
		 (loop (cdr bindings) bindings))
		(else
		 (loop (cdr bindings) bindings))))))))

;*---------------------------------------------------------------------*/
;*    failure? ...                                                     */
;*---------------------------------------------------------------------*/
(define (failure? exp)
   (match-case exp
      ((failure ?- ?- ?-)
       #t)
      (else
       #f)))
