;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/bigloo1.7/comptime1.7/Assert/walk.scm ...                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  9 18:40:24 1993                          */
;*    Last change :  Tue Aug  9 10:00:35 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On fait la passe des assertions                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module assert_walk
   (include "Var/variable.sch")
   (import  assert_get
	    assert_put
	    assert_make
	    tools_speek
	    tools_error
	    tools_shape)
   (export  (assert-walk tree)))

;*---------------------------------------------------------------------*/
;*    assert-walk ...                                                  */
;*---------------------------------------------------------------------*/
(define (assert-walk tree)
   (verbose "   . Assert" #\Newline)
   (start-partial-error "Assert")
   (let loop ((walk tree))
      (if (null? walk)
	  (begin
	     (fail-if-partial-error)
	     tree)
	  (let* ((var     (car walk))
		 (value   (global-value var))
		 (body    (function-body value))
		 (formals (function-args value)))
	     (enter-function (shape var))
	     (get-assertions! body)
	     (function-body-set! value
				 (make-body-assert
				  formals
				  (put-assertions! body)
				  (global-info var)))
	     (leave-function)
	     (loop (cdr walk))))))







