;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.7/Assert/put.scm ...       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 10 10:53:12 1993                          */
;*    Last change :  Thu Sep  8 09:27:24 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On met les assertions dans les champs info des variables         */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module assert_put
   (include "Assert/assert.sch"
	    "Var/variable.sch"
	    "Tools/trace.sch")
   (import  assert_make
	    assert_get
	    tools_shape
	    heap_abstract)
   (export  (put-assertions! exp)))

;*---------------------------------------------------------------------*/
;*    put-assertions! ...                                              */
;*---------------------------------------------------------------------*/
(define (put-assertions! exp)
   (trace assert "put-assertions!: " (shape exp) #\Newline)
   (match-case exp
;*--- atom ------------------------------------------------------------*/
      ((atom ?-)
       exp)
;*--- quote -----------------------------------------------------------*/
      ((quote ?-)
       exp)
;*--- pragma ----------------------------------------------------------*/
      ((pragma ?-)
       exp)
;*--- assert ----------------------------------------------------------*/
      ((assert check . ?-)
       (make-one-assert exp (abstract-unspecified) (cadddr exp)))
      ((assert . ?-)
       (abstract-unspecified))
;*--- begin -----------------------------------------------------------*/
      ((begin . ?body)
       (let loop ((hook body))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (put-assertions! (car hook)))
		 (loop (cdr hook))))))
;*--- set! ------------------------------------------------------------*/
      ((set! ?var ?val)
       (set-car! (cddr exp) (put-assertions! val))
       exp)
;*--- let -------------------------------------------------------------*/
      ((let ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (put-assertions! body))
		 exp)
	      (begin
		 (set-car! (cdr (car hook))
			   (put-assertions! (car (cdar hook))))
		 (loop (cdr hook))))))
;*--- labels ----------------------------------------------------------*/
      ((labels ?bindings ?body)
       (let loop ((hook bindings))
	  (if (null? hook)
	      (begin
		 (set-car! (cddr exp) (put-assertions! body))
		 exp)
	      (let* ((value (local-value (caar hook)))
		     (body  (function-body value))
		     (args  (function-args value)))
		 (set-car! (cddr (car hook))
			   (make-body-assert args
					     (put-assertions! body)
					     (local-info (caar hook))))
		 (function-body-set! value (caddar hook))
		 (loop (cdr hook))))))
;*--- failure ---------------------------------------------------------*/
      ((failure ?proc ?msg ?obj)
       (set-car! (cdr exp) (put-assertions! proc))
       (set-car! (cddr exp) (put-assertions! msg))
       (set-car! (cdddr exp) (put-assertions! obj))
       exp)
;*--- bind-exit -------------------------------------------------------*/
      ((bind-exit ?- ?body)
       (set-car! (cddr exp) (put-assertions! body))
       exp)
;*--- apply & funcall -------------------------------------------------*/
      (((or apply funcall) . ?-)
       (let loop ((hook (cdr exp)))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (put-assertions! (car hook)))
		 (loop (cdr hook))))))
;*--- typed-case ------------------------------------------------------*/
      ((typed-case ?type ?test . ?clauses)
       (set-car! (cddr exp) (put-assertions! test))
       (let loop ((hook clauses))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! (cdr (car hook)) (put-assertions!
					     (cadr (car hook))))
		 (loop (cdr hook))))))
;*--- if --------------------------------------------------------------*/
      ((cif ?si ?alors ?sinon)
       (set-car! (cdr exp) (put-assertions! si))
       (set-car! (cddr exp) (put-assertions! alors))
       (set-car! (cdddr exp) (put-assertions! sinon))
       exp)
;*--- block -----------------------------------------------------------*/
      ((block ?- ?body)
       (set-car! (cddr exp) (put-assertions! body))
       exp)
;*--- return-from -----------------------------------------------------*/
      ((return-from ?- ?val)
       (set-car! (cddr exp) (put-assertions! val))
       exp)
;*--- application -----------------------------------------------------*/
      (else
       (let loop ((hook exp))
	  (if (null? hook)
	      exp
	      (begin
		 (set-car! hook (put-assertions! (car hook)))
		 (loop (cdr hook))))))))

