;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/bigloo1.7/comptime1.7/Assert/make.scm ...                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Nov 10 15:43:17 1993                          */
;*    Last change :  Tue Aug  9 11:16:15 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    On pose les assertions ...                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module assert_make
   (include "Assert/assert.sch"
	    "Var/variable.sch"
	    "Tools/trace.sch"
	    "Foreign/type.sch")
   (import   scan_lexical
	     heap_abstract
	     assert_get
	     tools_shape)
   (export   (make-body-assert formals body info)
	     (make-one-assert assert body formals)))

;*---------------------------------------------------------------------*/
;*    make-entering-assert ...                                         */
;*---------------------------------------------------------------------*/
(define (make-entering-assert asserts body formals)
   (trace assert "make-entering-assert: " (shape asserts) #\Newline)
   (let loop ((asserts asserts)
	      (body    body))
      (if (null? asserts)
	  body
	  (loop (cdr asserts)
		(make-one-assert (car asserts) body formals)))))

;*---------------------------------------------------------------------*/
;*    make-exiting-assert ...                                          */
;*---------------------------------------------------------------------*/
(define (make-exiting-assert asserts body formals)
   (trace assert "make-exiting-assert: " (shape asserts) #\Newline)
   (if (null? asserts)
       body
       (let ((aux (allocate-local-variable 'assert-aux)))
	  `(begin
	      (set! ,(abstract-assert-exiting-value) ,body)
	      ,(let loop ((asserts asserts)
			  (body    (abstract-assert-exiting-value)))
		  (if (null? asserts)
		      body
		      (loop (cdr asserts)
			    (make-one-assert (car asserts) body formals))))))))
 
;*---------------------------------------------------------------------*/
;*    make-one-assert ...                                              */
;*---------------------------------------------------------------------*/
(define (make-one-assert assert body formals)
   (trace assert "make-one-assert: " (shape assert) #\Newline)
   (let ((scope        (cadr assert))
	 (a-shape      (caddr assert))
	 (pred         (car (cddddr assert)))
	 (l            (allocate-local-variable 'l))
	 (assert-shape (lambda (v)
			  (cond
			     ((local? v)
			      (local-name v))
			     ((global? v)
			      (global-name v))
			     (else
			      (shape v))))))
      `(begin
	  ;; on test l'assertion
	  (cif ,pred
	       ,(abstract-unspecified)
	       (begin
		  ;; on declare les variables `assertees' a l'interprete
		  ,@(let loop ((formals formals)
			       (defs    '()))
		       (if (null? formals)
			   defs
			   (loop (cdr formals)
				 (cons (abstract
					'define-primop-ref!
					`',(assert-shape (car formals))
					(abstract 'location (car formals)))
				       defs))))
		  ;; on notify que l'assertion a echoue.
		  ,(abstract 'notify-assert-fail
			     `',(map assert-shape formals)
			     (let loop ((f formals))
				(if (null? f)
				    (abstract-nil)
				    (abstract 'c-cons
					      (car f)
					      (loop (cdr f)))))
			     `',a-shape)
		  ;; on supprime les variables
		  ,@(let loop ((formals formals)
			       (defs    '()))
		       (if (null? formals)
			   defs
			   (loop (cdr formals)
				 (cons (abstract
					'assert-unbind!
					`',(assert-shape (car formals)))
				       defs)))))) 
	  ,body)))

;*---------------------------------------------------------------------*/
;*    make-body-assert ...                                             */
;*    -------------------------------------------------------------    */
;*    On pose les assertions de debut et de fin de bloc.               */
;*---------------------------------------------------------------------*/
(define (make-body-assert formals body info)
   (trace assert "make-body-assert: " (shape formals) #\Newline)
   ;; on commence par rechercher les assertions de debut et de fin
   (if (not (assert? info))
       body
       (make-entering-assert (assert-entering info)
			     (make-exiting-assert (assert-exiting info)
						  body
						  formals)
			     formals)))
