;;; Copyright (c) 1993 Gustavus Adolphus College.  All rights reserved.
;;; 
;;; This software was developed by Gustavus Adolphus College (GAC).
;;; mission to copy this software, to redistribute it, and to use it
;;; for any purpose is granted, subject to the following restrictions and
;;; understandings.
;;; 
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;; 
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the GAC Mathematics and Computer Science Department any
;;; improvements or extensions that they make, so that these may be
;;; included in future releases; and (b) to inform GAC of noteworthy uses
;;; of this software.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. GAC makes no express or implied warranty or representation of any
;;; kind with respect to this software, including any warranty that the
;;; operation of this software will be error-free.  ANY IMPLIED WARRANTY
;;; OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE IS HEREBY
;;; DISCLAIMED.  GAC is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of Gustavus Adolphus College nor of
;;; any adaptation thereof in any advertising, promotional, or sales
;;; literature without prior written consent from GAC in each case.

;; Basic block for "Repeating Crosses" quilting pattern from
;; "Quick-and-Easy Strip Quilting" by Helen Whitson Rose, Dover
;; Publications, New York, 1989, p. 60.
(define rcross-bb
  (ps-image "newpath -1 1 moveto 1 1 lineto 1 -1 lineto .5 -.5 lineto
               .5 .5 lineto -.5 .5 lineto closepath fill
             newpath -.5 -.5 moveto -.5 .5 lineto .5 -.5 lineto closepath fill"
            100))

;; An much simpler basic block, with one corner black.
(define corner-bb
  (ps-image "newpath 0 1 moveto 1 1 lineto 1 0 lineto closepath fill" 100))

;; Basic block for "Blowing in the Wind" quilting pattern from
;; "Quick-and-Easy Strip Quilting" by Helen Whitson Rose, Dover
;; Publications, New York, 1989, p. 59.
(define bitw-bb
  (ps-image
   "newpath .5 -.5 moveto 1 0 lineto 1 1 lineto 0 0 lineto closepath fill
    newpath -.5 .5 moveto 0 1 lineto -1 1 lineto closepath fill
    newpath -1 -1 moveto 1 -1 lineto 0 -1 lineto -1 0 lineto closepath fill"
   100))

;; A simple test image, to illustrate transformations.
(define test-bb
  (ps-image "/Helvetica findfont .3 scalefont setfont
             -.9 .6 moveto (This end up) show" 
            100))
