;;; This code is adapted from Structure and Interpretation of Computer
;;; Programs, by Harold Abelson and Gerald Jay Sussman with Julie
;;; Sussman, MIT Press, 1985.  Copyright 1985 by The Massachusetts
;;; Institute of Technology.

(define-machine gcd
                (registers a b t)
                (controller
                 test-b:
                 (branch (zero? (fetch b)) gcd-done:)
                 (assign t (remainder (fetch a) (fetch b)))
                 (assign a (fetch b))
                 (assign b (fetch t))
                 (goto test-b:)
                 gcd-done:))

(remote-assign gcd 'a 18)
(remote-assign gcd 'b 24)
(start gcd)
(proceed gcd)
(set-pc gcd '*start*)
(step gcd)
(proceed gcd)
