;;; gack.scm -- The Imaginary World of Gack was adapted from
;;; PS6-WORLD.SCM from MIT, to which the following copyright
;;; notice applied.  The adaptation is by Max Hailperin
;;; <max@nic.gac.edu> 10/11/91, revised 3/10/92.

;;; Copyright (c) 1990 Massachusetts Institute of Technology
;;; 
;;; This material was developed by the Scheme project at the 
;;; Massachusetts Institute of Technology, Department of Electrical 
;;; Engineering and Computer Science.  Permission to copy this 
;;; material, to redistribute it, and to use it for any 
;;; non-commercial purpose is granted, subject to the following 
;;; restrictions and understandings.
;;;
;;; 1. Any copy made of this material must include this copyright 
;;; notice in full.
;;; 
;;; 2. Users of this material agree to make their best efforts (a) 
;;; to return to the MIT Scheme project any improvements or 
;;; extensions that they make, so that these may be included in 
;;; future releases; and (b) to inform MIT of noteworthy uses of 
;;; this material.
;;;
;;; 3. All materials developed as a consequence of the use of this
;;; material shall duly acknowledge such use, in accordance with 
;;; the usual standards of acknowledging credit in academic 
;;; research.
;;;
;;; 4. MIT has made no warrantee or representation that this 
;;; material (including the operation of software contained 
;;; therein) will be error-free, and MIT is under no obligation to 
;;; provide any services, by way of maintenance, update, or 
;;; otherwise.
;;;
;;; 5. In conjunction with products arising from the use of this 
;;; material, there shall be no use of the name of the 
;;; Massachusetts Institute of Technology nor of any adaptation 
;;; thereof in any advertising, promotional, or sales literature 
;;; without prior written consent from MIT in each case. 

;;;
;;; You can add more definitions to this file to make them part of the
;;; world.  They should go *after* the (initialize-clock-list) below, so
;;; any animate beings you add are properly moved.  You can reinitialize
;;; the world by re-eveluating this entire file.  Remember that if you
;;; change the definition of make-person (for example) the already existing
;;; people won't be effected.  Thus, you should re-evaluate this file
;;; after any changes you make to the make-xxxx procedures.

(initialize-clock-list)

;; Here we define the places in the imaginary world of Gack

(define food-service (make-place 'food-service))
(define PO (make-place 'PO))
(define alumni-hall (make-place 'alumni-hall))
(define chamber-of-great-white-wizard 
  (make-place 'chamber-of-great-white-wizard))
(define brer (make-place 'brer))
(define good-ship-olin (make-place 'good-ship-olin))
(define lounge (make-place 'lounge))
(define computer-lab (make-place 'computer-lab))
(define offices (make-place 'offices))
(define dormitory (make-place 'dormitory))
(define pond (make-place 'pond))


;; One-way paths connect individual places in the world.

(define (can-go from direction to)
  (ask from 'new-neighbor direction to))

(can-go food-service 'down PO)
(can-go PO 'south alumni-hall)
(can-go alumni-hall 'north food-service)
(can-go alumni-hall 'east chamber-of-great-white-wizard)
(can-go alumni-hall 'west brer)
(can-go chamber-of-great-white-wizard 'west alumni-hall)
(can-go chamber-of-great-white-wizard 'south dormitory)
(can-go dormitory 'north chamber-of-great-white-wizard)
(can-go dormitory 'west good-ship-olin)
(can-go brer 'east alumni-hall)
(can-go brer 'south good-ship-olin)
(can-go good-ship-olin 'north brer)
(can-go good-ship-olin 'east dormitory)
(can-go good-ship-olin 'up lounge)
(can-go lounge 'down good-ship-olin)
(can-go lounge 'west computer-lab)
(can-go lounge 'south offices)
(can-go computer-lab 'east lounge)
(can-go offices 'north lounge)

;; We define persons as follows:


(define max (make-person 'max offices 2))
(install-person max)

(define karl (make-person 'karl computer-lab 4))
(install-person karl)

(define barbara (make-witch 'barbara offices 3))
(install-person barbara)

(define elvee (make-great-white-wizard 'elvee chamber-of-great-white-wizard 1))
(install-person elvee)

(define scroll-of-enlightenment (make-scroll 'scroll-of-enlightenment))
(ask brer 'appear scroll-of-enlightenment)

(for-each (lambda (title)
           (ask brer 'appear (make-scroll title)))
         '(crime-and-punishment war-and-peace illiad collected-works-of-rilke))

(define unix-programmers-manual (make-scroll 'unix-programmers-manual))
(ask computer-lab 'appear unix-programmers-manual)

(define next-users-reference (make-scroll 'next-users-reference))
(ask computer-lab 'appear next-users-reference)