;;; Copyright (c) 1993 Gustavus Adolphus College.  All rights reserved.
;;; 
;;; This software was developed by Gustavus Adolphus College (GAC).
;;; mission to copy this software, to redistribute it, and to use it
;;; for any purpose is granted, subject to the following restrictions and
;;; understandings.
;;; 
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;; 
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the GAC Mathematics and Computer Science Department any
;;; improvements or extensions that they make, so that these may be
;;; included in future releases; and (b) to inform GAC of noteworthy uses
;;; of this software.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. GAC makes no express or implied warranty or representation of any
;;; kind with respect to this software, including any warranty that the
;;; operation of this software will be error-free.  ANY IMPLIED WARRANTY
;;; OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE IS HEREBY
;;; DISCLAIMED.  GAC is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of Gustavus Adolphus College nor of
;;; any adaptation thereof in any advertising, promotional, or sales
;;; literature without prior written consent from GAC in each case.

;;; This file implements the procedures move-to and reset-plot.
;;; They have been defined as #f so that they are bound in the
;;; global environment.  Those bindings are modified using set! in
;;; the following let expression, in order that the procedures are
;;; in the scope of the three state variables.  Those three state
;;; variables (cur-x, cur-y, and cur-heading) keep track of the
;;; robot car's status.
;;; 
;;;   Written by Max Hailperin, modified by Karl Knight
;;; 

(define move-to #f)
(define reset-plot #f)

(let ((cur-x 0)
      (cur-y 0)
      (cur-heading 0))
  (set! reset-plot (lambda ()
                     'reset-plot-not-done))
  (set! move-to (lambda (x y)
                  (let ((dx (- x cur-x))
                        (dy (- y cur-y)))
                    'move-to-not-done))))