;;; Copyright (c) 1992 Gustavus Adolphus College.  All rights reserved.
;;; 
;;; This software was developed by Gustavus Adolphus College (GAC).
;;; mission to copy this software, to redistribute it, and to use it
;;; for any purpose is granted, subject to the following restrictions and
;;; understandings.
;;; 
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;; 
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the GAC Mathematics and Computer Science Department any
;;; improvements or extensions that they make, so that these may be
;;; included in future releases; and (b) to inform GAC of noteworthy uses
;;; of this software.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. GAC makes no express or implied warranty or representation of any
;;; kind with respect to this software, including any warranty that the
;;; operation of this software will be error-free.  ANY IMPLIED WARRANTY
;;; OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE IS HEREBY
;;; DISCLAIMED.  GAC is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of Gustavus Adolphus College nor of
;;; any adaptation thereof in any advertising, promotional, or sales
;;; literature without prior written consent from GAC in each case.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; This file contains some procedures for Lab 5 in MC27 for
;; Spring, 1992
;;
;;         Author: Karl Knight
;;         Date  : April 21, 1992
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The implementation of the ADT "point", i.e., 2-dimensional
;; coordinates as well as the useful procedure draw-line.
;;
(define (make-point x y)
  (cons x y))

(define (x-coord p)
  (car p))

(define (y-coord p)
  (cdr p))


(define (draw-line p1 p2)
  (position-pen (x-coord p1) (y-coord p1))
  (draw-line-to (x-coord p2) (y-coord p2)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; This part defines the extent of the graph as well as a
;; procedure which will draw a scaled grid (i.e., the coordinate
;; axes) in the graphics window.
;;
(enable-language-features)
(define number->string number->string)
(disable-language-features)

(define top-of-grid     188)
(define bottom-of-grid -188)
(define right-of-grid   188)
(define left-of-grid   -188)

(define (draw-grid x-max y-max)
  (define (draw-ticks n)
    (if (<= n 5)
        (let ((y-value (* (/ n 5) top-of-grid))
              (x-value (* (/ n 5) right-of-grid)))
          (draw-line (make-point 0 y-value)
                     (make-point 5 y-value))
          (graphics-text (number->string (/ (* y-max n) 5))
                         10 (- y-value 5))
          (draw-line (make-point 0 (- y-value))
                     (make-point 5 (- y-value)))
          (graphics-text (number->string (/ (* (- y-max) n) 5))
                         10 (- (- y-value) 5))
          (draw-line (make-point x-value 0)
                     (make-point x-value -5))
          (graphics-text (number->string (/ (* x-max n) 5))
                         (- x-value 5) -20)
          (draw-line (make-point (- x-value) 0)
                     (make-point (- x-value) -5))
          (graphics-text (number->string (/ (* (- x-max) n) 5))
                         (- (- x-value) 5) -20)
          (draw-ticks (+ n 1)))))
  (clear-graphics)
  (draw-line (make-point 0 bottom-of-grid)
             (make-point 0 top-of-grid))
  (draw-line (make-point left-of-grid 0)
             (make-point right-of-grid 0))
  (draw-ticks 1))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The following procedure will apply the procedure p to each
;; element of the list l.  This is similar to mapcar, differing
;; only in that it has no meaningful return value; it is done
;; for effect.
;;
(define (for-each p l)
  (if (null? l)
      'done
      (sequence
        (p (car l))
        (for-each p (cdr l)))))
