;;; This was adapted from MIT 6.001 spring 1984 problem set 2 -- Lunar
;;; lander, which bore the following copyright notice:
;;; Copyright (c) 1990 Massachusetts Institute of Technology
;;; 
;;; This material was developed by the Scheme project at the 
;;; Massachusetts Institute of Technology, Department of Electrical 
;;; Engineering and Computer Science.  Permission to copy this 
;;; material, to redistribute it, and to use it for any 
;;; non-commercial purpose is granted, subject to the following 
;;; restrictions and understandings.
;;;
;;; 1. Any copy made of this material must include this copyright 
;;; notice in full.
;;; 
;;; 2. Users of this material agree to make their best efforts (a) 
;;; to return to the MIT Scheme project any improvements or 
;;; extensions that they make, so that these may be included in 
;;; future releases; and (b) to inform MIT of noteworthy uses of 
;;; this material.
;;;
;;; 3. All materials developed as a consequence of the use of this
;;; material shall duly acknowledge such use, in accordance with 
;;; the usual standards of acknowledging credit in academic 
;;; research.
;;;
;;; 4. MIT has made no warrantee or representation that this 
;;; material (including the operation of software contained 
;;; therein) will be error-free, and MIT is under no obligation to 
;;; provide any services, by way of maintenance, update, or 
;;; otherwise.
;;;
;;; 5. In conjunction with products arising from the use of this 
;;; material, there shall be no use of the name of the 
;;; Massachusetts Institute of Technology nor of any adaptation 
;;; thereof in any advertising, promotional, or sales literature 
;;; without prior written consent from MIT in each case. 



;; The constructor "make-ship-state" and selectors "height",
;; "velocity", and "fuel" for the data structure "ship-state"
;; are loaded from the following compiled file:
(load "~karl/Public/MC27/shipState.com")

;; The procedure "show-ship-state" involves some graphics hacking
;; and is loaded from the following uncompiled file:
(load "~karl/Public/MC27/display-ship.scm")

(define (update ship-state fuel-burn-rate)
  (make-ship-state
   (+ (height ship-state) (* (velocity ship-state) dt))
   (+ (velocity ship-state)
      (* (+ (* engine-strength fuel-burn-rate) gravity) dt))
   (- (fuel ship-state) (* fuel-burn-rate dt))))

(define (lander-loop ship-state)
  (show-ship-state ship-state)
  (if (landed? ship-state)
      (end-game ship-state)
      (lander-loop (update ship-state (get-burn-rate)))))

(define (landed? ship-state)
  (<= (height ship-state) 0))

(define (end-game ship-state)
  (let ((final-velocity (velocity ship-state)))
    (print final-velocity)
    (cond ((>= final-velocity safe-velocity)
           (print "good landing"))
          (else
           (print "you crashed!")))
    'game-over))

(define (get-burn-rate)
  (newline)
  (newline)
  (princ "Enter a burn rate (between 0 and 1), then <enter> ")
  (newline)
  (read))

(define (play)
  (reset-graphics)
  (lander-loop initial-ship-state))

(define initial-ship-state (make-ship-state 50 0 20))

(define dt 2)
(define gravity -.5)
(define safe-velocity -2)
(define engine-strength 1)

;; Three simple strategies (see problem #3 in the lab)
(define (full-burn ship-state) 1)
(define (no-burn ship-state) 0)
(define (ask-user ship-state) (get-burn-rate))
