;;; Copyright (c) 1992 Gustavus Adolphus College.  All rights reserved.
;;; 
;;; This software was developed by Gustavus Adolphus College (GAC).
;;; mission to copy this software, to redistribute it, and to use it
;;; for any purpose is granted, subject to the following restrictions and
;;; understandings.
;;; 
;;; 1. Any copy made of this software must include this copyright
;;; notice in full.
;;; 
;;; 2. Users of this software agree to make their best efforts (a) to
;;; return to the GAC Mathematics and Computer Science Department any
;;; improvements or extensions that they make, so that these may be
;;; included in future releases; and (b) to inform GAC of noteworthy uses
;;; of this software.
;;; 
;;; 3. All materials developed as a consequence of the use of this
;;; software shall duly acknowledge such use, in accordance with the usual
;;; standards of acknowledging credit in academic research.
;;; 
;;; 4. GAC makes no express or implied warranty or representation of any
;;; kind with respect to this software, including any warranty that the
;;; operation of this software will be error-free.  ANY IMPLIED WARRANTY
;;; OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE IS HEREBY
;;; DISCLAIMED.  GAC is under no obligation to provide any services, by
;;; way of maintenance, update, or otherwise.
;;; 
;;; 5. In conjunction with products arising from the use of this material,
;;; there shall be no use of the name of Gustavus Adolphus College nor of
;;; any adaptation thereof in any advertising, promotional, or sales
;;; literature without prior written consent from GAC in each case.

;; This is a slightly fancier version of the show-ship-state
;; procedure.  To use it, evaluate the contents of this file
;; _after_ having evaluated the contents of "lunar.scm".
;;
;; We have also added a rescaling feature, so that the rocket
;; is always on screen.
;;
;;     Authors: Karl Knight and Max Hailperin
;;     Date   : October 29, 1992

;;--------------------------------------------------------------
;; Init-graphics and grab the stuff needed from MIT Scheme

(init-graphics) ;must precede access of graphics-device below
(enable-language-features)
(define number->string number->string)
(define graphics-disable-buffering graphics-disable-buffering)
(define graphics-enable-buffering graphics-enable-buffering)
(define sicp-graphics-window
  (access graphics-device graphics-package))
(set! timer-interrupt (lambda x '()))
(disable-language-features)

;;--------------------------------------------------------------
;; The following procedures deal with the graph's scale.

(define top-grid-value 100)
(define top-of-grid    185)
(define bottom-of-grid -185)
(define scale-factor   (/ (- top-of-grid bottom-of-grid)
                          top-grid-value))
(define (init-scale)
  (set! top-grid-value 100)
  (set! scale-factor  (/ (- top-of-grid bottom-of-grid)
                         top-grid-value)))
(define (double-scale)
  (set! top-grid-value  (* top-grid-value  2))
  (set! scale-factor  (/ (- top-of-grid bottom-of-grid)
                         top-grid-value)))
(define (halve-scale)
  (set! top-grid-value  (/ top-grid-value  2))
  (set! scale-factor  (/ (- top-of-grid bottom-of-grid)
                         top-grid-value)))

(define (rescale half-or-double)
  (graphics-enable-buffering sicp-graphics-window)
  (if (equal? half-or-double 'half)
      (halve-scale)
      (double-scale))
  (graphics-text "Rescaling" 60 120)
  (graphics-disable-buffering sicp-graphics-window)
  (wait-microseconds 1000000))

;;--------------------------------------------------------------
;; The following procedures do the drawing and other display
;;  in the graphics window.

(define (draw-line x1 y1 x2 y2)
  (position-pen x1 y1)
  (draw-line-to x2 y2))

(define (draw-ship at-height)
  (let ((height (+ bottom-of-grid (* at-height scale-factor))))
    (let ((x0 0)
          (x1 (* 1 scale-factor))
          (x2 (* 1.5 scale-factor))
          (x3 (* 2 scale-factor))
          (x4 (* 2.5 scale-factor))
          (x5 (* 4 scale-factor))
          (y1 height)
          (y2 (+ height (* 2.5 scale-factor)))
          (y3 (+ height (* 4 scale-factor)))
          (y4 (+ height (* 6 scale-factor)))
          (y5 (+ height (* 10 scale-factor)))
          (y6 (+ height (* 15 scale-factor))))
      (draw-line    x1  y1    x4  y1)     ; right burner
      (draw-line    x4  y1    x3  y2)
      (draw-line    x2  y2     4  y1)
      (draw-line (- x1) y1 (- x4) y1)     ; right burner
      (draw-line (- x4) y1 (- x3) y2)
      (draw-line (- x2) y2 (- x1) y1)
      (draw-line (- x4) y2    x4  y2)     ; bottom
      (draw-line (- x4) y2 (- x4) y5)     ; left side
      (draw-line    x4  y2    x4  y5)     ; right side
      (draw-line (- x4) y5    x0  y6)     ; cone
      (draw-line    x4  y5    x0  y6)
      (draw-line (- x4) y3 (- x5) y3)     ; left fin
      (draw-line (- x5) y3 (- x4) y4)
      (draw-line    x4  y3    x5  y3)     ; right fin
      (draw-line    x5  y3    x4  y4))))

(define (draw-grid)
  (define (draw-ticks n)
    (if (<= n 10)
        (let ((y-value (+ bottom-of-grid
                          (* (/ (* top-grid-value n) 10)
                             scale-factor))))
          (position-pen -60 y-value)
          (draw-line-to -50 y-value)
          (graphics-text (number->string (/ (* top-grid-value n)
                                            10))
                         -40 (- y-value 5))
          (draw-ticks (+ n 1)))))
  (position-pen -50 bottom-of-grid)
  (draw-line-to -50 top-of-grid)
  (draw-ticks 0))

(define (display-state-values ship-state)
  (graphics-text "height  :" 60 -50)
  (graphics-text "velocity:" 60 -65)
  (graphics-text "fuel      :" 60 -80)
  (graphics-text "time      :" 60 -110)
  (graphics-text (number->string (height ship-state)) 120 -50)
  (graphics-text (number->string (velocity ship-state)) 120 -65)
  (graphics-text (number->string (fuel ship-state)) 120 -80)
  (graphics-text (number->string time) 120 -110))

;;--------------------------------------------------------------
;; The following procedures deal with the graph's scale.

(define printing-enabled #T)
(define (enable-printing)
  (set! printing-enabled #T))
(define (disable-printing)
  (set! printing-enabled #F))

(define (print-ship-state ship-state)
  (print (list
          'height (height ship-state)
          'velocity (velocity ship-state)
          'fuel (fuel ship-state))))

;;--------------------------------------------------------------
;; The following procedures deal with the graph's scale.

(define time 0)
(define next-time (real-time-clock))
(define (reset-clock) (set! time 0))

;;--------------------------------------------------------------
;; The following procedures deal with the graph's scale.

(define (show-ship-state ship-state)
  (maybe-gc)
  (if (> (height ship-state) top-grid-value)
      (rescale 'double))
  (if (and (< (height ship-state) (* .4 top-grid-value))
           (< 100 top-grid-value))
      (rescale 'half))
  (graphics-enable-buffering sicp-graphics-window)
  (clear-graphics)
  (draw-ship (height ship-state))
  (draw-grid)
  (display-state-values ship-state)
  (wait-until (lambda () (>= (real-time-clock) next-time)))
  (set! next-time (+ (real-time-clock) (* dt 1000)))
  (set! time (+ time dt))
  (graphics-disable-buffering sicp-graphics-window)
  (if printing-enabled (print-ship-state ship-state)))

(define (reset-graphics)
  (init-scale)
  (reset-clock))