;; This is the version of sqrt and its supporting routines from 
;; section 1.1.7 of "Structure and Interpretation of Computer 
;; Programs" by Harold Abelsonand Gerald Jay Sussman, copyright 
;; 1985 by The Massachusetts Institute of Technology.

(define (square x) (* x x))

(define (abs x)
  (if (< x 0) (- x) x))

(define (sqrt-iter guess x)
  (if (good-enough? guess x)
      guess
      (sqrt-iter (improve guess x)
                 x)))

(define (improve guess x)
  (average guess (/ x guess)))

(define (average x y)
  (/ (+ x y) 2))

(define (good-enough? guess x)
  (< (abs (- (square guess) x)) .001))

(define (sqrt x)
  (sqrt-iter 1 x))
