;;; -*- Scheme -*- PS9-PRIM.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Spring Semester, 1991
;;
;;				 Problem Set 9

(define (compile-unknown-application app c-t-env target cont)
  (preserving
   'env
   (compile-expression (operator app) c-t-env 'fun 'next)
   (preserving 'fun
               (compile-operands (operands app) c-t-env)
               (compile-call target cont))))

(define (compile-application app c-t-env target cont)
  (define (unknown)
    (compile-unknown-application app c-t-env target cont))

  (let ((op (operator app)))
    (if (not (variable-expression? op))
	(unknown)
	(let ((name (variable-expression-name op)))
	  (let ((lexical-address
		 (variable->lexical-address name c-t-env)))
	    (if lexical-address
		(unknown)
		(let ((pair (assq name primitive-open-codings)))
		  (if (not pair)
		      (unknown)
		      (open-code-primitive (cdr pair)
					   app
					   c-t-env
					   target
					   cont)))))))))

(define (open-code-primitive open-coder app c-t-env target cont)
  (if (not (= (length (cdr app)) (open-coder-arity open-coder)))
      (error "open-code-primitive: Incorrect number of arguments"
	     app)
      (let ((regs (nthcdr (- (length argument-registers)
			     (open-coder-arity open-coder))
			  argument-registers)))
	(append-instruction-sequences
	 (compile-primitive-operands
	  (operands app)
	  regs
	  c-t-env)
	 (apply (open-coder-handler open-coder)
		(cons target regs))
	 (compile-continuation cont)))))

(define (compile-primitive-operands exps regs c-t-env)
  (cond ((null? regs)
	 (error "compiled-primitive-operands: Not enough registers"))
	((last-operand? exps)
	 (compile-expression (first-operand exps)
			     c-t-env
			     (car regs)
			     'next))
	(else
	 (preserving
	  'env
	  (compile-expression (first-operand exps)
			      c-t-env
			      (car regs)
			      'next)
	  (without-clobbering
	   (car regs)
	   (compile-primitive-operands (rest-operands exps)
				       (cdr regs)
				       c-t-env))))))

(define (without-clobbering reg seq)
  (if (modifies-register seq reg)
      (wrap-save-restore seq reg)
      seq))

(define argument-registers
  '(arg0 arg1 arg2 arg3))

(define (make-open-coder name arity handler)
  (cond ((zero? arity)
	 (error "make-open-coder: Cannot handle primitives with no arguments"
		name))
	((> arity (length argument-registers))
	 (error "make-open-coder: Primitive takes too many arguments"
		name))
	(else
	 (cons arity handler))))

(define (open-coder-arity oc)
  (car oc))

(define (open-coder-handler oc)
  (cdr oc))

(define (binary-open-coding name)
  (cons name
	(make-open-coder
	 name
	 2
	 (lambda (target op1 op2)
	   (open-code-binary name target op1 op2)))))

(define (unary-open-coding name)
  (cons name
	(make-open-coder
	 name
	 1
	 (lambda (target op1)
	   (open-code-unary name target op1)))))

(define (open-code-binary name target op1 op2)
  (make-register-assignment
   target
   (make-operation name
		   (make-fetch op1)
		   (make-fetch op2))))

(define (open-code-unary name target op1)
  (error "open-code-unary: Not yet written" name))

(define primitive-open-codings
  (list (binary-open-coding '+)
	(binary-open-coding '-)
	(binary-open-coding '*)
	(binary-open-coding '/)
	(binary-open-coding '=)
	(binary-open-coding '<)
	(binary-open-coding '>)
	(binary-open-coding 'eq?)
	(binary-open-coding 'cons)
	(unary-open-coding 'null?)
	(unary-open-coding 'atom?)
	(unary-open-coding 'zero?)
	(unary-open-coding 'car)
	(unary-open-coding 'cdr)
	(unary-open-coding '1+)
	(unary-open-coding '-1+)
	))