;; -*- Scheme -*- PS9-LEXICAL.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Spring Semester, 1991
;;
;;				 Problem Set 9
;;; -*- Scheme -*-

(define (compile-variable-expression exp c-t-env target cont)
  (append-instruction-sequences
   (let ((name (variable-expression-name exp)))
     (let ((lexical-address (variable->lexical-address name c-t-env)))
       (if (not lexical-address)
	   (compile-unknown-variable name c-t-env target)
	   (compile-known-variable lexical-address target))))
   (compile-continuation cont)))

(define (compile-unknown-variable name c-t-env target)
  (append-instruction-sequences
   (make-get-variable-binding name c-t-env)
   (make-register-assignment target
			     (make-operation 'binding-value
					     (make-fetch 'arg0)))))

(define (compile-known-variable lexical-address target)
  (append-instruction-sequences
   (make-get-lexically-addressed-binding lexical-address)
   (make-register-assignment target
			     (make-operation 'binding-value
					     (make-fetch 'arg0)))))

(define (make-get-lexically-addressed-binding lexical-address)
  (append-instruction-sequences
   (make-register-assignment
    'arg0
    (make-operation 'nth
		    (make-constant
		     (lexical-address-depth lexical-address))
		    (make-fetch 'env)))
   (make-register-assignment
    'arg0
    (make-operation 'nth
		    (make-constant
		     (lexical-address-offset lexical-address))
		    (make-fetch 'arg0)))))

(define (variable->lexical-address name c-t-env)
  (define (offset-in-frame frame offset)
    (cond ((null? frame)
	   false)
	  ((eq? name (car frame))
	   offset)
	  (else
	   (offset-in-frame (cdr frame) (1+ offset)))))

  (define (find-in-env env depth)
    (if (null? env)
	false
	(let ((offset (offset-in-frame (car env) 0)))
	  (if offset
	      (make-lexical-address depth offset)
	      (find-in-env (cdr env) (1+ depth))))))

  (find-in-env c-t-env 0))

(define (make-lexical-address depth offset)
  (cons depth offset))

(define (lexical-address-depth la)
  (car la))

(define (lexical-address-offset la)
  (cdr la))