;; -*- Scheme -*- PS9-ECEVAL.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Spring Semester, 1991
;;
;;				 Problem Set 9

;;;; 6.001 Explicit-Control Register-Machine Evaluator

;;;from 4.1.4, with expanded set of primitive procedures

(define (setup-environment)
  (let ((initial-env
    (extend-environment primitive-procedure-names
                        primitive-procedure-objects
                        '())))
  (define-variable! 'nil nil initial-env)
  (define-variable! 't (not nil) initial-env)
  initial-env))

(define (primitive-procedure? proc)
  (if (atom? proc)
      nil
      (eq? (car proc) 'primitive)))

(define (primitive-id proc) (cadr proc))


(define primitive-procedure-names
  '(car cdr cons eq? atom? number? even? null? + - * / -1+ 1+ < > = clear-graphics
	zero? print))

(define primitive-procedure-objects
  '((primitive car)
    (primitive cdr)
    (primitive cons)
    (primitive eq?)
    (primitive atom?)
    (primitive number?)
    (primitive even?)
    (primitive null?)
    (primitive +)
    (primitive -)
    (primitive *)
    (primitive /)
    (primitive -1+)
    (primitive 1+)
    (primitive <)
    (primitive >)
    (primitive =)
    (primitive clear-graphics)		;;;
    (primitive zero?)
    (primitive user-print)
    ))

(define the-global-environment (setup-environment))

;;;from 5.2.1
(define (apply-primitive-procedure p args)
  (apply (eval (primitive-id p) user-initial-environment)
         (reverse args)))

(define (make-bindings proc args)
  (extend-binding-environment (parameters proc)
                              args
                              (procedure-environment proc)))

(define (extend-binding-environment vars args env)
  (extend-environment vars (reverse args) env))

;;;from 5.3.6

(define (user-print object)
  (cond ((compound-procedure? object)
         (print (list 'compound-procedure
                      (parameters object)
                      (procedure-body object)
                      "[procedure-env]")))
        ((compiled-procedure? object)
         (princ "[compiled-procedure]"))
        (else (print object))))

;; with stuff from 5.3.6 for compiler-eceval interface

(define-machine explicit-control-evaluator
  (registers exp env val continue fun argl unev
	     arg0 arg1 arg2 arg3)			; APH
  (controller
read-eval-print-loop
  (perform (initialize-stack))
  (perform (initialize-ops-counter))                   ;;;
  (perform (newline))
  (perform (princ "EC-EVAL==> "))
  (assign exp (read-from-keyboard))
  ;; -- Start of APH mods
  (branch (not (pair? (fetch exp)))
	  start-evaluation)
  (assign unev (car (fetch exp)))
  (branch (eq? (fetch unev) 'QUIT)
	  exit-interpreter)
  (branch (not (eq? (fetch unev) 'COMPILED))
	  start-evaluation)
  (assign exp (cadr (fetch exp)))
  (assign val (compile (fetch exp)))
  (assign val (link (fetch val)))
  (goto external-entry)	  
start-evaluation
  ;; -- End of APH mods
  (assign env the-global-environment)
  (assign continue print-result)
  (goto eval-dispatch)
print-result
  (perform (user-print (fetch val)))
  (goto read-eval-print-loop)
unknown-procedure-type-error
  (assign val 'unknown-procedure-type-error)
  (goto signal-error)

unknown-expression-type-error
  (assign val 'unknown-expression-type-error)
  (goto signal-error)

signal-error
  (perform (user-print (fetch val)))
  (goto read-eval-print-loop)

external-entry
   (perform (initialize-stack))
   (assign env the-global-environment)
   (assign continue print-result)
   (save continue)
   (goto (fetch val))

eval-dispatch
  (branch (self-evaluating? (fetch exp)) ev-self-eval)
  (branch (quoted? (fetch exp)) ev-quote)
  (branch (variable? (fetch exp)) ev-variable)
  (branch (definition? (fetch exp)) ev-definition)
  (branch (assignment? (fetch exp)) ev-assignment)
  (branch (lambda? (fetch exp)) ev-lambda)
  (branch (conditional? (fetch exp)) ev-cond)
  ;; -- Start of APH mods
  (branch (variable-expression? (fetch exp)) ev-variable-2)
  (branch (if? (fetch exp)) ev-if)
  (branch (let? (fetch exp)) ev-let)
  (branch (sequence? (fetch exp)) ev-sequence)
  ;; -- End of APH mods
  (branch (no-args? (fetch exp)) ev-no-args)
  (branch (application? (fetch exp)) ev-application)
  (goto unknown-expression-type-error)
ev-self-eval
  (assign val (fetch exp))
  (goto (fetch continue))
ev-quote
  (assign val (text-of-quotation (fetch exp)))
  (goto (fetch continue))
ev-variable
  (assign val
          (lookup-variable-value (fetch exp) (fetch env)))
  (goto (fetch continue))
ev-lambda
  (assign val (make-procedure (fetch exp) (fetch env)))
  (goto (fetch continue))
ev-no-args
  (assign exp (operator (fetch exp)))
  (save continue)
  (assign continue setup-no-arg-apply)
  (goto eval-dispatch)
setup-no-arg-apply
  (assign fun (fetch val))
  (assign argl '())
  (goto apply-dispatch)
ev-application
  (assign unev (operands (fetch exp)))
  (assign exp (operator (fetch exp)))
  (save continue)
  (save env)
  (save unev)
  (assign continue eval-args)
  (goto eval-dispatch)
eval-args
  (restore unev)
  (restore env)
  (assign fun (fetch val))
  (save fun)
  (assign argl '())
  (goto eval-arg-loop)

eval-arg-loop
  (save argl)
  (assign exp (first-operand (fetch unev)))
  (branch (last-operand? (fetch unev)) eval-last-arg)
  (save env)
  (save unev)
  (assign continue accumulate-arg)
  (goto eval-dispatch)
accumulate-arg
  (restore unev)
  (restore env)
  (restore argl)
  (assign argl (cons (fetch val) (fetch argl)))
  (assign unev (rest-operands (fetch unev)))
  (goto eval-arg-loop)
eval-last-arg
  (assign continue accumulate-last-arg)
  (goto eval-dispatch)
accumulate-last-arg
  (restore argl)
  (assign argl (cons (fetch val) (fetch argl)))
  (restore fun)
  (goto apply-dispatch)

apply-dispatch
  (branch (primitive-procedure? (fetch fun)) primitive-apply)
  (branch (compound-procedure? (fetch fun)) compound-apply)
  (branch (compiled-procedure? (fetch fun)) compiled-apply)
  (goto unknown-procedure-type-error)
compiled-apply
   (assign val (compiled-procedure-entry (fetch fun)))
   (goto (fetch val))
primitive-apply
  (assign val
          (apply-primitive-procedure (fetch fun)
                                     (fetch argl)))
  (restore continue)
  (goto (fetch continue))
compound-apply
  (assign env (make-bindings (fetch fun) (fetch argl)))
  (assign unev (procedure-body (fetch fun)))
  (goto eval-sequence)
eval-sequence
  (assign exp (first-exp (fetch unev)))
  (branch (last-exp? (fetch unev)) last-exp)
  (save unev)
  (save env)
  (assign continue eval-sequence-continue)
  (goto eval-dispatch)
eval-sequence-continue
  (restore env)
  (restore unev)
  (assign unev (rest-exps (fetch unev)))
  (goto eval-sequence)
last-exp
  (restore continue)
  (goto eval-dispatch)

ev-cond
  (save continue)
  (assign unev (clauses (fetch exp)))
evcond-pred
  (branch (no-clauses? (fetch unev)) evcond-return-nil)
  (assign exp (first-clause (fetch unev)))
  (branch (else-clause? (fetch exp)) evcond-else-clause)
  (save env)
  (save unev)
  (assign exp (predicate (fetch exp)))
  (assign continue evcond-decide)
  (goto eval-dispatch)

evcond-return-nil
  (restore continue)
  (assign val nil)
  (goto (fetch continue))
evcond-decide
  (restore unev)
  (restore env)
  (branch (true? (fetch val)) evcond-true-predicate)
  (assign unev (rest-clauses (fetch unev)))
  (goto evcond-pred)
evcond-true-predicate
  (assign exp (first-clause (fetch unev)))
evcond-else-clause
  (assign unev (actions (fetch exp)))
  (goto eval-sequence)
ev-assignment
  (assign unev (assignment-variable (fetch exp)))
  (save unev)
  (assign exp (assignment-value (fetch exp)))
  (save env)
  (save continue)
  (assign continue ev-assignment-1)
  (goto eval-dispatch)
ev-assignment-1
  (restore continue)
  (restore env)
  (restore unev)
  (perform
   (set-variable-value! (fetch unev) (fetch val) (fetch env)))
  (goto (fetch continue))
ev-definition
  (assign unev (definition-variable (fetch exp)))
  (save unev)
  (assign exp (definition-value (fetch exp)))
  (save env)
  (save continue)
  (assign continue ev-definition-1)
  (goto eval-dispatch)
ev-definition-1
  (restore continue)
  (restore env)
  (restore unev)
  (perform
   (define-variable! (fetch unev) (fetch val) (fetch env)))
  (assign val (fetch unev)) 
  (goto (fetch continue))

  ;; -- Start of APH mods

ev-if
  (save continue)
  (assign continue if-decide)
  (assign unev (if-exps (fetch exp)))
  (save env)
  (save unev)
  (assign exp (if-pred (fetch unev)))
  (goto eval-dispatch)

if-decide
  (restore unev)
  (restore env)
  (restore continue)
  (branch (true? (fetch val)) if-true-predicate)
  (assign exp (if-alter (fetch unev)))
  (goto eval-dispatch)

if-true-predicate
  (assign exp (if-conseq (fetch unev)))
  (goto eval-dispatch)  

ev-let
  (save continue)
  (assign unev (fetch exp))
  (save unev)
  (assign unev (let-value-expressions (fetch exp)))
  (assign argl '())
  (branch (null? (fetch unev)) ev-let-bind)
  (assign exp (car (fetch unev)))
  (save argl)
  (save env)
  (save unev)
  (assign continue ev-let-values)
  (goto eval-dispatch)

ev-let-values
  (restore unev)
  (restore env)
  (restore argl)
  (assign argl (cons (fetch val) (fetch argl)))
  (assign unev (cdr (fetch unev)))
  (branch (null? (fetch unev)) ev-let-bind)
  (assign exp (car (fetch unev)))
  (save argl)
  (save env)
  (save unev)
  (goto eval-dispatch)
  
ev-let-bind
  (restore unev)
  (assign env
	  (extend-binding-environment (let-names (fetch unev))
				      (fetch argl)
				      (fetch env)))
  (assign unev (let-body (fetch unev)))
  (goto eval-sequence)  

ev-sequence
  (save continue)
  (assign unev (sequence-actions (fetch exp)))
  (goto eval-sequence)

ev-variable-2
  (save continue)
  (assign continue ev-variable-fetch)
  (assign exp (variable-expression-name (fetch exp)))
  (goto get-variable-binding)

ev-variable-fetch
  (assign val (binding-value (fetch arg0)))
  (restore continue)
  (goto (fetch continue))

get-variable-binding
  (assign arg3 get-variable-flame)

get-variable-binding-shared
  (branch (no-more-frames? (fetch env))
	  get-variable-error)

get-variable-binding-loop
  (assign arg1 (first-frame (fetch env)))
  (branch (null? (fetch arg1))
	  get-variable-binding-loop-next)

assq-loop
  (assign arg0 (car (fetch arg1)))
  (assign arg2 (binding-variable (fetch arg0)))
  (branch (eq? (fetch exp) (fetch arg2))
	  get-variable-found)
  (assign arg1 (cdr (fetch arg1)))
  (branch (not (null? (fetch arg1)))
	  assq-loop)

get-variable-binding-loop-next
  (assign env (rest-frames (fetch env)))
  (branch (not (no-more-frames? (fetch env)))
	  get-variable-binding-loop)

get-variable-error
  (goto (fetch arg3))

get-variable-flame
  (perform (princ (list "No such variable" (fetch exp))))
  (goto signal-error)

get-variable-found
  (goto (fetch continue))

get-variable-binding/define
  (save continue)
  (assign continue get-variable-binding-success)
  (assign arg3 get-variable-define-in-global)
  (goto get-variable-binding-shared)

get-variable-binding-success
  (restore continue)
  (goto (fetch continue))

get-variable-define-in-global
  (restore continue)
  (assign env the-global-environment)
  (perform
   (define-variable! (fetch exp) '*UNASSIGNED* (fetch env)))
  (goto get-variable-binding)

  ;; -- End of APH mods

  ;;end of controller of explicit-control-evaluator
exit-interpreter
  ))

;;;a short procedure, for convenience

(define (go)
  (start explicit-control-evaluator))

;;;from 5.3.6 for compiler interface

(define (compile-and-go expression)
  (remote-assign
   explicit-control-evaluator
   'val
   (link (compile expression)))				; -- APH
  (eval '(goto external-entry)
        explicit-control-evaluator))

(define (link compiled-expression)			; -- APH
  (build-instruction-list explicit-control-evaluator
			  compiled-expression))

(define (make-compiled-procedure entry env)
  (list 'compiled-procedure entry env))

(define (compiled-procedure? proc)
  (if (atom? proc)
      nil
      (eq? (car proc) 'compiled-procedure)))

(define (compiled-procedure-entry proc)
  (cadr proc))

(define (compiled-procedure-env proc)
  (caddr proc))