;;; AMB code to explore searching for rational numbers

;;; Implementation of the rational abstraction and some utilities

(define (make-rat n d)
  (let ((g (gcd n d)))
    (cons (/ n g) (/ d g))))

(define numer car)
(define denom cdr)

(define (+rat r1 r2)
  (make-rat (+ (* (denom r2) (numer r1))
               (* (denom r1) (numer r2)))
            (* (denom r1) (denom r2))))

(define (*rat r1 r2)
  (make-rat (* (numer r1) (numer r2))
            (* (denom r1) (denom r2))))

(define (rat->number r)
  (/ (numer r) (denom r)))


;;; Enumerating an interval of integers

(define (a-number-between low high)
  (cond ((= low high) low)
	(else
	 (amb low (a-number-between (1+ low) high)))))

;;; Enumerating the rationals with numerator and denominator no greater than n:

(define (a-rational-to n)
  (let ((num (a-number-between 1 n))
        (den (a-number-between 1 n)))
    (make-rat num den)))

;;; A sloppy test to see if the rat is close to the number:

(define (rational-approximation number k)
  (let ((rat (a-rational-to k)))
    (cond ((close-enuf? number rat) rat)
	  (else (fail)))))

(define (close-enuf? number rat)
  (< (abs (- (rat->number rat) number)) 0.01))


;;; Ben's definitions

(define (a-natural-number)
  (amb 1
       (1+ (a-natural-number))))

(define (a-positive-rational)
  (let ((num (a-natural-number))
        (den (a-natural-number)))
    (make-rat num den)))

(define (bens-rational-approximation x)
  (let ((r (a-positive-rational)))
    (cond ((close-enuf? x r) r)
	  (else (fail)))))

;;; Problem 1 and Problem 2

(define (mem r)
  (cond ((equal? r (a-positive-rational)) r)
	(else (fail))))

;;; You need to redefine A-RATIONAL so that MEM works.



;;; Problem 3
;;; A divide-and-conquer method for finding a rational approximation to a number:


(define make-interval cons)
(define start car)
(define end cdr)

(define (midpoint int)
  (*rat (make-rat 1 2)
        (+rat (start int) (end int))))

(define (approx n)
  (define (loop int)
    (cond ((not (in? n int)) (fail))
	  ((small-enuf? int) (midpoint int))
	  (else (loop (split int)))))
  (cond ((< n 0) 'error)
	((> n 1) 'error)
	(else (loop (make-interval (make-rat 0 1) (make-rat 1 1))))))

(define (in? n int)
  (cond ((< n (rat->number (start int))) false)
	((> n (rat->number (end int))) false)
	(else true)))

(define (small-enuf? int)
  (let ((b (rat->number (start int)))
        (e (rat->number (end int))))
    (< (- e b) 0.001)))


(define (split interval)
  "Your code goes here"
  )
