;;; -*- Mode:Scheme; Package:S&ICP; Base:10 -*-

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                           ;;
;; PS5-ANS.SCM -- Digital Circuit Simulator answer file            Spring 91 ;;
;;                                                                           ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; \   /      ---
;;;  \ /  /-\  | /
;;;   |  |   | |/
;;;   |   \-/  o
;;;   
;;; AT GREAT EXPENSE TO THE 6.001 STAFF....  we have carefully prepared this  
;;; answer file to help organize your solutions and to gratiously provide you
;;; loads of ducky test routines. We have provided everything here that you may
;;; have reason to modify.  THEREFORE, your tutor will likely be quite dis-
;;; appointed if you decide not to fill in your answers in this file...  so
;;; disappointed that this dissappointment might reflect in your problem
;;; set grade.  HAVE A NICE DAY!  (Oh, feel free to replace this message with
;;; feedback to your tutor...  ;-)

;;;============================================================================
;;; PART I --- Warm-up Exercises:  Mutable Data
;;;============================================================================

;;-----------------------------------------------------------------------------
;; Problem 1.1 [Exercise 3.12] --- Performing APPEND!-ectomies
;;-----------------------------------------------------------------------------

; Give yourself blank space to work here, or work it out on a separate sheet &
; give a pointer to it.

;;-----------------------------------------------------------------------------
;; Problem 1.2 [Exercise 3.22] --- Message Passing Queues
;;-----------------------------------------------------------------------------

;; Replace the following queue implementation with your own message-passing
;; based implementation... Use your message-passing based implementation for
;; the remainder of this problem set.

(define (empty-queue? queue) (null? (front-ptr queue)))

(define (make-queue) (cons '() '()))

(define (front queue)
  (if (empty-queue? queue)
      (error "FRONT called with an empty queue" queue)
      (car (front-ptr queue))))

(define (insert-queue! queue item)
  (let ((new-pair (cons item '())))
    (cond ((empty-queue? queue)
           (set-front-ptr! queue new-pair)
           (set-rear-ptr!  queue new-pair)
           queue)
          (else
           (set-cdr! (rear-ptr queue) new-pair)
           (set-rear-ptr!      queue  new-pair)
           queue)))) 

(define (delete-queue! queue)
  (cond ((empty-queue? queue)
         (error "Delete called with an empty queue" queue))
        (else
         (set-front-ptr! queue (cdr (front-ptr queue)))
         queue))) 

;;;
;;; To isolate you from any errors you may have made in the queue definition of
;;;  problem 1.2 above, you should now execute the next line:

(load "ps5-code.scm")

;;-----------------------------------------------------------------------------
;; Problem 1.3 [Exercise 3.28] --- Implementing "raw" OR-GATEs
;;-----------------------------------------------------------------------------
;; Replace the ERROR calls with your answers.

(define (or-gate o1 o2 output)
  (error "OR-GATE is not yet defined: you must do Problem 1.3 [Exercise 3.28] first."))

(define (logical-or s1 s2)
  (error "LOGICAL-OR is not yet defined: you must do Problem 1.3 [Exercise 3.28] first."))

(define or-gate-delay 5)	; As prescribed in the S&ICP text

;--------------------------------------------------
(define test-or-in-1 'placeholder)
(define test-or-in-2 'placeholder)
(define test-or-out  'placeholder)

(define (prepare-for-or-gate-tester!)
  (reset-agenda!)

  (set! test-or-in-1 (make-wire))
  (set! test-or-in-2 (make-wire))
  (set! test-or-out  (make-wire))

  (or-gate test-or-in-1 test-or-in-2 test-or-out)

  (probe 'TEST-OR-OUT test-or-out)	; should tell me initial value is low

  (propagate)	; should be nothing to prop since wires initialize to low
  (newline)     ; but still consumes one OR-GATE-DELAY on the agenda
  )

(define (test-or!)
  (prepare-for-or-gate-tester!)

  (set-signal! test-or-in-1 high)
  (propagate)	; should say value set to high after two OR-GATE-DELAY
  (newline)

  (set-signal! test-or-in-2 high)
  (propagate)	; silence.... already high (time now three OR-GATE-DELAYs)
  (newline)

  (set-signal! test-or-in-1 low)
  (propagate)	; silence.... still high   (time now four OR-GATE-DELAYs)
  (newline)

  (set-signal! test-or-in-2 low)
  (propagate)	; should say value set to low after five OR-GATE-DELAYs.
  )

;;----------------------------------------------------------------------------
;; Problem 1.4 --- Environment Diagram time...
;;----------------------------------------------------------------------------

; Work this out on a separate sheet of paper.

;-----------------------------------------------------
(define in  (make-wire))
(define out (make-wire))
(inverter in out)

; Draw resulting environment diagram including THE-AGENDA

(propagate)

; Update the environment diagram.

;;-----------------------------------------------------------------------------
;; Discussion Problem [Exercise 3.31] --- Clowning around with the Half-Adder
;;-----------------------------------------------------------------------------

(define (half-adder a b s c)
  (let ((d (make-wire))
	(e (make-wire)))
;   (probe 'HALF-ADDER-D d)	; You may want to uncomment these probes to
;   (probe 'HALF-ADDER-E e)	;  get a clearer view of what's going on.
    ( or-gate a b d)
    (and-gate a b c)
    (inverter c e)
    (and-gate d e s)))

; You may find the following useful if you modify ACCEPT-ACTION-PROCEDURE...

(define (test-half-adder!)
  (clown-around-with-half-adder!))


(define ha-in-1  'placeholder)
(define ha-in-2  'placeholder)
(define ha-sum   'placeholder)
(define ha-carry 'placeholder)

(define (prepare-to-clown-around-with-half-adder!)
  (reset-agenda!)

  (set! ha-in-1  (make-wire))
  (set! ha-in-2  (make-wire))
  (set! ha-sum   (make-wire))
  (set! ha-carry (make-wire))

  (probe 'HA-SUM   ha-sum)
  (probe 'HA-CARRY ha-carry)

  (half-adder ha-in-1 ha-in-2 ha-sum ha-carry)
  )

(define (clown-around-with-half-adder!)
  (prepare-to-clown-around-with-half-adder!)

  (newline)
  (newline)(princ "* Should see:")
  (newline)(princ "*   sum 8 New-value = high")
  (newline)(princ "*   done")
  (newline)(princ "* Answer produced: ")
  (set-signal! ha-in-1 high)
  (propagate)

  (newline)
  (newline)(princ "* Should see:")
  (newline)(princ "*   carry 11 New-value = high")
  (newline)(princ "*   sum   16 New-value = low")
  (newline)(princ "*   done")
  (newline)(princ "* Answer produced: ")
  (set-signal! ha-in-2 high)
  (propagate)

  (newline)
  (newline)(princ "-----------------------------")
  (newline)(princ " Yow! Are we having fun yet? ")
  (newline)(princ "-----------------------------")
  )

;;----------------------------------------------------------------------------
;; Discussion Problem [Exercise 3.32] --- Why a TIME-SEGMENT is a QUEUE
;;----------------------------------------------------------------------------

; You should find the following useful if you alter the implementation to trace
; how it loses

(define test-and-in-1 'placeholder)
(define test-and-in-2 'placeholder)
(define test-and-out  'placeholder)

(define (test-and!)
  (reset-agenda!)

  (set! test-and-in-1 (make-wire))
  (set! test-and-in-2 (make-wire))
  (set! test-and-out  (make-wire))

  (and-gate test-and-in-1
	    test-and-in-2 test-and-out)

  (probe 'TEST-AND-OUT test-and-out)

  (set-signal! test-and-in-1 low)
  (set-signal! test-and-in-2 high)
  (propagate)	; should propagate nothing since (logical-and low high) ==> low; 
  (newline)     ;  wires are initialized to low

  (set-signal! test-and-in-1 high)
  (set-signal! test-and-in-2 low)
  (propagate)   ; should go through high back to low (think about it).
  )             ; consider modifying time-segments to be stacks instead and
                ; consider how it fails

;;;============================================================================
;;; PART II ---  Latches:  Digital Circuits with State
;;;============================================================================

;;----------------------------------------------------------------------------
;; Problem 2.1 --- OR-Latches can latch a high
;;----------------------------------------------------------------------------

(define (or-latch in out)
  (error "OR-LATCH is not yet defined: you must do Problem 2.1 first."))

;--------------------------------------------------------
(define or-latch-in  'placeholder)
(define or-latch-out 'placeholder)

(define (test-or-latch!) ; You should run this test, explain what should happen
  (reset-agenda!)	 ;  and why and print out a demonstration that your
                         ;  code works correctly
  (set! or-latch-in  (make-wire))
  (set! or-latch-out (make-wire))

  (or-latch or-latch-in or-latch-out)

  (probe 'OR-LATCH-OUT or-latch-out)

  (propagate)
  (newline)

  (set-signal! or-latch-in high)
  (propagate)
  (newline)

  (set-signal! or-latch-in low)
  (propagate)
  (newline)

  (set-signal! or-latch-in high)
  (propagate)
  )

;;----------------------------------------------------------------------------
;; Problem 2.1 continued --- AND-Latches can latch a low
;;----------------------------------------------------------------------------

(define (and-latch in out)
  (error "AND-LATCH is not yet defined: you must do Problem 2.1 first."))

;----------------------------------------
(define and-latch-in  'placeholder)
(define and-latch-out 'placeholder)

(define (test-and-latch!) ; You should run this test, explain what should
  (reset-agenda!)	  ;  happen and why and print out a demonstration that
			  ;  your code works correctly
  (set! and-latch-in  (make-wire))
  (set! and-latch-out (make-wire))

  (and-latch and-latch-in and-latch-out)

  (probe 'AND-LATCH-OUT and-latch-out)

  (propagate)
  (newline)

  (set-signal! and-latch-in low)
  (propagate)
  (newline)

  (set-signal! and-latch-in high)
  (propagate)
  (newline)

  (set-signal! and-latch-in low)
  (propagate)
  )

;;----------------------------------------------------------------------------
;; Problem 2.2 --- RS-Latches can latch both low's and high's (RESET/SET-Latches)
;;----------------------------------------------------------------------------

(define (rs-latch s r-low out)
  (error "RS-LATCH is not yet defined: you must do Problem 2.2 first."))

;----------------------------------------
(define test-s     'placeholder)
(define test-r-low 'placeholder)
(define test-out   'placeholder)

(define (prepare-to-test-rs-latch!)
  (reset-agenda!)

  (set! test-s     (make-wire))
  (set! test-r-low (make-wire))
  (set! test-out   (make-wire))

  (rs-latch test-s test-r-low test-out)

  (probe 'TEST-OUT test-out)

  (propagate)
  (newline)
  )

(define (test-rs-latch!)
  (prepare-to-test-rs-latch!)

  (set-signal! test-r-low high)	; Figure out for yourself why this is a useful
  (propagate)			;  sequence of tests and explain it (along with
  (newline)			;  your test results) in your solutions.

  (set-signal! test-s     high)
  (propagate)
  (newline)

  (set-signal! test-s     low)
  (propagate)
  (newline)

  (set-signal! test-r-low low)
  (propagate)
  (newline)

  (set-signal! test-s     high)
  (propagate)
  (newline)

  (set-signal! test-s     low)
  (propagate)
  (newline)

  (set-signal! test-r-low high)
  (propagate)
  )
;------------------------------------------------------
(define (relax-rs!)
  (prepare-to-test-rs-latch!)

  (set-signal! test-s     high)
  (propagate)			; After this, S = high and R = low
  (newline)

  (set-signal! test-s     low)	; De-assert both S and R
  (set-signal! test-r-low high)

  (newline)
  (newline) (princ "Here's where the fun starts...")
  (propagate)			; ...and watch the sparks fly!
  )
;------------------------------------------------------

(define (raw-rs-latch s r-low out)
  (error "RAW-RS-LATCH is not yet defined: you must do Problem 2.2 c first."))

;;;============================================================================
;;; PART III ---  Races and contaminated signals
;;;============================================================================

;;----------------------------------------------------------------------------
;; Problem 3.1 --- Simulating racy circuits
;;----------------------------------------------------------------------------

;
; In the MONGO-RACE below, the output MONGO-LATE-OR-OUT makes _____ transitions
;  before stabilizing

;------------------------------------------------------
; This demonstrates a two-input transition race in our Half-Adder device.

(define (race-half-adder!)
  (prepare-to-clown-around-with-half-adder!)
  (newline)

  (set-signal! ha-in-1 high)	; Establish A=high,B=low
  (propagate)
  (newline)

  (set-signal! ha-in-1 low)
  (set-signal! ha-in-2 high)	; Establish A=low,B=high

  (newline)
  (newline) (princ "Here's where the action starts...")
  (propagate)			; Observe double transition on SUM
  )

; This implements an OR-gate with an A=high->low hazard.

(define (racy-or o1 o2 output)
  (let ((not-o1        (make-wire))
	(o2-and-not-o1 (make-wire)))
    (inverter o1 not-o1)
    (and-gate o2 not-o1 o2-and-not-o1)
    (or-gate o1
	     o2-and-not-o1
	     output)))

(define racy-or-in-1 'placeholder)
(define racy-or-in-2 'placeholder)
(define racy-or-out  'placeholder)

(define (race-or!)
  (set! racy-or-in-1 (make-wire))
  (set! racy-or-in-2 (make-wire))
  (set! racy-or-out  (make-wire))
  
  (racy-or racy-or-in-1 racy-or-in-2 racy-or-out)

  (probe 'RACY-OR-IN-1 racy-or-in-1)
  (probe 'RACY-OR-IN-2 racy-or-in-2)
  (probe 'RACY-OR-OUT  racy-or-out )

  (propagate)
  (newline)

  (set-signal! racy-or-in-1 high)
  (set-signal! racy-or-in-2 high)
  (propagate)
  (newline)

  (reset-agenda!)
  (set-signal! racy-or-in-1 low)
  (newline)
  (newline)(princ "Here's where the interesting stuff starts...")
  (propagate)
  )

; This implements our mongo racy circuit.

(define mongo-in-1             'placeholder)
(define mongo-in-2             'placeholder)
(define mongo-and-out          'placeholder)

(define mongo-inv-out          'placeholder)

(define mongo-race-and-out     'placeholder)
(define mongo-race-or-out      'placeholder)
(define mongo-race-or-inv-out  'placeholder)
(define mongo-race-and-inv-out 'placeholder)

(define mongo-late-or-out      'placeholder)

(define (prepare-for-mongo-race!)
  (reset-agenda!)

  (set! mongo-in-1 	       (make-wire))
  (set! mongo-in-2 	       (make-wire))
  (set! mongo-and-out  	       (make-wire))

  (set! mongo-inv-out  	       (make-wire))

  (set! mongo-race-and-out     (make-wire))
  (set! mongo-race-or-out      (make-wire))
  (set! mongo-race-or-inv-out  (make-wire))
  (set! mongo-race-and-inv-out (make-wire))

  (set! mongo-late-or-out      (make-wire))

  (and-gate mongo-in-1             mongo-in-2            mongo-and-out)
  (inverter mongo-in-2             mongo-inv-out)
  (or-gate  mongo-and-out          mongo-inv-out         mongo-race-or-out)
  (and-gate mongo-and-out          mongo-race-or-out     mongo-race-and-out)
  (inverter mongo-race-and-out     mongo-race-and-inv-out)
  (inverter mongo-race-or-out      mongo-race-or-inv-out)
  (or-gate  mongo-race-and-inv-out mongo-race-or-inv-out mongo-late-or-out)

  (probe 'MONGO-IN-1             mongo-in-1)
  (probe 'MONGO-IN-2             mongo-in-2)
  (probe 'MONGO-AND-OUT          mongo-and-out )

  (probe 'MONGO-INV-OUT          mongo-inv-out)

  (probe 'MONGO-RACE-AND-OUT     mongo-race-and-out)
  (probe 'MONGO-RACE-OR-OUT      mongo-race-or-out)
  (probe 'MONGO-RACE-OR-INV-OUT  mongo-race-or-inv-out)
  (probe 'MONGO-RACE-AND-INV-OUT mongo-race-and-inv-out)

  (probe 'MONGO-LATE-OR-OUT      mongo-late-or-out)

  (propagate)
  (newline)
  )

(define (mongo-race!)
  (prepare-for-mongo-race!)

  (set-signal! mongo-in-1 high)
  (propagate)
  (newline)

  (set-signal! mongo-in-2 high)
  (newline)
  (newline)(princ "*** Here's where all the real action starts...")
  (propagate)
  )

;;----------------------------------------------------------------------------
;; Problem 3.2 --- The ``contaminated'' signal abstraction
;;----------------------------------------------------------------------------

;;; The following code from the simulator implements the signal abstraction.
;;; Modify this and add what is needed to make the required generalization.


(define high 1)
(define low  0)
(define same-signal? =)

(define (high? s)
  (same-signal? s high))

(define (low? s)
  (same-signal? s low))

;;----------------------------------------------------------------------------
;; Problem 3.3 --- Generalized logic functions
;;----------------------------------------------------------------------------


(define (logical-not s)			; ** Modify this
  (cond ((low? s) high)
        ((high? s) low)
        (else (error "Invalid signal -- LOGICAL-NOT" s))))


(define (logical-and s1 s2)		; ** Modify this
  (cond ((low? s1) low)
	((low? s2) low)
	((and (high? s1) (high? s2)) high)
	(else (error "Invalid signal -- LOGICAL-AND" s1 s2))))


;(define (logical-or uls1 uls2)		; ** Modify this
;  (error "LOGICAL-OR undefined: must do Problem 3.3 first")) 


;;----------------------------------------------------------------------------
;; Problem 3.4 --- Generalized logic devices
;;----------------------------------------------------------------------------

(define (inverter input output)		; ** Modify this
  (define (invert-input)
    (let ((new-value (logical-not (get-signal input))))
      (after-delay inverter-delay
                   (lambda ()
                     (set-signal! output
                                  new-value)))))
  (add-action! input invert-input))

(define (and-gate a1 a2 output)		; ** Modify this
  (define (and-action-procedure)
    (let ((new-value (logical-and (get-signal a1)
				  (get-signal a2))))
      (after-delay and-gate-delay
                   (lambda ()
                     (set-signal! output new-value)))))
  (add-action! a1 and-action-procedure)
  (add-action! a2 and-action-procedure))

:(define (or-gate o1 o2 output)		; ** Modify this
;  (error "OR-GATE undefined: you must do Problem 3.4 first"))

;;----------------------------------------------------------------------------
;; Problem 3.5 --- Generalized wires
;;----------------------------------------------------------------------------

(define (make-wire)			; ** Modify this
  (let ((signal-value       low)
	(action-procedures '()))

    (define (set-my-signal! new-value)
      (if (not (same-signal? signal-value new-value))
          (sequence (set! signal-value new-value)
		    (call-each action-procedures))
          'done))

    (define (accept-action-procedure proc)
      (set! action-procedures (cons proc action-procedures))
      (proc))

    (define (dispatch m)
      (cond ((eq? m 'get-signal ) signal-value)
            ((eq? m 'set-signal!) set-my-signal!)
            ((eq? m 'add-action!) accept-action-procedure)
            (else (error "Unknown operation -- WIRE" m))))

    dispatch))

