;;; At least for debugging, let me try some simple definitions:

(define make-rect list)

(define origin car)
(define horiz cadr)
(define vert caddr)


(define make-vect cons)

(define xcor car)
(define ycor cdr)


;;; Operations on vectors:

(define (+vect v1 v2)
  (make-vect (+ (xcor v1) (xcor v2))
             (+ (ycor v1) (ycor v2))))

(define (-vect v1 v2)
  (make-vect (- (xcor v1) (xcor v2))
             (- (ycor v1) (ycor v2))))

(define (scale-vect v factor)
  (make-vect (* factor (xcor v))
             (* factor (ycor v))))

(define (rotate-vect v angle)
  (let ((c (cos angle)) (s (sin angle)))
    (make-vect (- (* c (xcor v)) (* s (ycor v)))
	       (+ (* c (ycor v)) (* s (xcor v))))))


;;; Lines

(define make-line list)
(define beg car)
(define end cadr)

