;;; Pictures are implemented as procedures that take rectangles and draw
;;; themselves in the rectangles.

(define (superpose picture-1 picture-2)
  (lambda (rect)
    (do-both (picture-1 rect)
	     (picture-2 rect))))

(define (rotate picture angle)
  (lambda (rect)
    (picture (rotated rect angle))))

(define (scale picture factor)
  (lambda (rect)
    (picture (scaled rect factor))))

(define (translate picture x y)
  (lambda (rect)
    (picture (translated rect x y))))


;;; Primitive pictures call the graphics system.
 
(define (line rect)
  (draw-line rect -1 0 1 0))

(define (half-line rect)
  (draw-line rect -.5 0 .5 0))



;;; Operations on rectangles:

(define (rotated rect angle)
  (make-rectangle (origin rect)				
                  (rotate-vect (horiz rect) angle)
                  (rotate-vect (vert rect) angle)))

(define (translated rect x y)
  (make-rectangle (+vect (origin rect)
                         (+vect (scale-vect (horiz rect) x)
                                (scale-vect (vert rect) y)))
                  (horiz rect)
                  (vert rect)))

(define (scaled rect factor)
  (make-rectangle (origin rect)
                  (scale-vect (horiz rect) factor)
                  (scale-vect (vert rect) factor)))
  

