(define the-screen
  (make-rectangle (make-vect 0.0 0.0)
		  (make-vect 1.0 0.0)
		  (make-vect 0.0 1.0)))

(define (draw picture)
  (clear-graphics)
  (picture the-screen))

(define (draw-line rectangle xl1 yl1 xl2 yl2)
  (let ((start (make-vect xl1 yl1))
        (end (make-vect xl2 yl2)))
    (let ((map (coord-map rectangle)))
      (let ((s (map start))
	    (e (map end)))
	(move-to! (xcor s) (ycor s))
	(line-to! (xcor e) (ycor e))))))

(define (coord-map rect)
  (lambda (point)
    (+vect (+vect (scale-vect (horiz rect) (xcor point))
                  (scale-vect (vert rect) (ycor point)))
           (origin rect))))

(define (do-both e1 e2)
  'done)