;;;This is the file OBJECT.SCM

;;;Simple object system with inheritance

(define (ask object message . args)
  (let ((method (object message)))
    (if (method? method)
	(apply method (cons object args))
	(error "No method" message (cadr method)))))

(define (get-method object message)
  (object message))

(define (no-method name)
  (list 'no-method name))

(define (no-method? x)
  (if (pair? x)
      (eq? (car x) 'no-method)
      false))

(define (method? x)
  (not (no-method? x)))

;;; The next few expressions, use SYNTAX-TABLE-DEFINE -- a way to create
;;; syntactic abbreviations.  We don't expect you to know how this
;;; code works.  But you should realize that it causes MAKE-OBJECT and
;;; OBJECT-COND to be set up as abbreviations.

(enable-language-features)

(syntax-table-define (access *student-syntax-table* student-package)
    'make-object
  (macro body
    `(sequence
       (define self (lambda (message) . ,body))
       self)))

(syntax-table-define (access *student-syntax-table* student-package)
    'object-cond
  (macro clauses
    `(cond . ,(mapcar process-method-clause clauses))))

(define (process-method-clause clause)
  (if (eq? (car clause) 'defmethod)
      (let ((name (caadr clause)) (args (cdadr clause)) (rest (cddr clause)))
	`((eq? message ',name) (lambda (self . ,args) . ,rest)))
      clause))

(disable-language-features)






