;;; This is the file PS6-ADV.SCM
;;; It uses the syntax for objects that is defined in the file
;;; ps6-object.scm (loaded separately)

;;; You should not need to modify this file, expect possibly for the
;;; open-ended problem at the end.  For the rest of the problem set, you
;;; should put your own definitions in a separate file, to keep it
;;; distinct from the code we have written.

;;; Each time you want to restart, you should load the file PS6-WORLD.SCM,
;;; which initializes the adventure game with some places and characters.


;;;Persons, places, and possessions will all be kinds of named objects

(define (make-named-object name)
  (make-object
   (object-cond
    (defmethod (name) name)
    (else (no-method name)))))

;;;A thing is something that can be owned

(define (make-thing name)
  (let ((n-o (make-named-object name))
	(owner 'no-one))
    (make-object
     (object-cond
      (defmethod (ownable?) true)
      (defmethod (owned?) (not (eq? owner 'no-one)))
      (defmethod (change-owner new-owner)
	(set! owner new-owner)
	'done)
      (defmethod (owner) owner)
      (else (get-method n-o message))))))

;;; Implementation of places

(define (make-place name)
  (let ((n-o (make-named-object name)) (neighbor-map '()) (things '()))
    (make-object
     (object-cond
      (defmethod (things) things)
      (defmethod (neighbors) (mapcar cdr neighbor-map))
      (defmethod (exits) (mapcar car neighbor-map))
      (defmethod (neighbor-towards direction)
	(let ((p (assq direction neighbor-map)))
	  (if (null? p) false (cdr p))))
      (defmethod (appear new-thing)
	(if (memq new-thing things)
	    (append (list (ask new-thing 'name))
		    '(is already at)
		    (list name))
	    (sequence (set! things (cons new-thing things))
		   'appeared)))
      (defmethod (gone thing)
	(if (not (memq thing things))
	    (append (list (ask thing 'name))
		    '(is not at)
		    (list name))
	    (sequence (set! things (delq thing things))
		   'disappeared)))
      (defmethod (new-neighbor direction new-neighbor)
	(if (assq direction neighbor-map)
	    (append '(direction already assigned) (list direction name))
	    (sequence (set! neighbor-map
			 (cons (cons direction new-neighbor) neighbor-map))
		   'connected)))
      (else (get-method n-o message))))))

;;;Implementation of people

(define (make-person name place threshold)
  (let ((possessions '())
	(restlessness 0)
	(n-o (make-named-object name)))
    (make-object
     (object-cond
      (defmethod (person?) true)
      (defmethod (place) place)
      (defmethod (possessions) possessions)
      (defmethod (exits) (ask place 'exits))
      (defmethod (move)
	(if (>= restlessness threshold)
	    (sequence (ask self 'act)
		   (set! restlessness 0))
	    (set! restlessness (1+ restlessness)))
	'moved)
      (defmethod (say list-of-stuff)
	(display-message
	 (append '("At") (list (ask place 'name)) '(":")
		 (list name) '("says --") list-of-stuff)))

      (defmethod (look-around)
	(let ((other-things (mapcar (lambda (thing) (ask thing 'name))
				    (delq self (ask place 'things)))))
	  (ask self 'say
	       (append '("I see")
		       (if (null? other-things)
			   '("nothing")
			   other-things)))))

      (defmethod (take thing)
	(if (if (memq thing (ask place 'things))
		(is-a thing 'ownable?)
		false)
	    (let ((owner (ask thing 'owner)))
	      (if (ask thing 'owned?)
		  (sequence (ask owner 'lose thing) (ask owner 'have-fit))
		  'unowned)
	      (ask thing 'change-owner self)
	      (set! possessions (cons thing possessions))
	      (ask self 'say (append '("I take") (list (ask thing 'name)))))
	    (append '(you can not take) (list (ask thing 'name)))))

	(defmethod (lose thing)
	  (if (eq? self (ask thing 'owner))
	      (sequence (set! possessions (delq thing possessions))
		     (ask thing 'change-owner 'no-one)
		     (ask self 'say
			  (append '("I lose") (list (ask thing 'name)))))
	      (append (list name) '(does not own) (ask thing 'name))))

	(defmethod (list-possessions)
	  (ask self 'say
	       (append '("I have")
		       (mapcar (lambda (p) (ask p 'name)) possessions))))

	(defmethod (go direction)
	  (let ((new-place (ask place 'neighbor-towards direction)))
	    (if (not (null? new-place))
		(ask self 'move-to new-place)
		(append '(you cannot go) (list direction) '(from)
			(list (ask place 'name))))))

	(defmethod (act)
	  (let ((new-place (random-place place)))
	    (if (not (null? new-place)) (ask self 'move-to new-place))))

	(defmethod (have-fit)
	  (ask self 'say '("Yaaaah! I am upset!")))

	(defmethod (move-to new-place)
	  (announce-move name place new-place)
	  (ask place 'gone self)
	  (for-each (lambda (p) (ask place 'gone p) (ask new-place 'appear p))
		    possessions)
	  (ask new-place 'appear self)
	  (set! place new-place)
	  (greet-people self (other-people-at-place self new-place))
	  'moved)
	(else (get-method n-o message))))))

;;; A troll is a kind of person

(define (make-troll name place threshold)
  (let ((p (make-person name place threshold)))
    (make-object
     (object-cond
      (defmethod (act)
	(let ((others (other-people-at-place self (ask self 'place))))
	  (if (not (null? others))
	      (ask self 'eat-person (pick-random others))
	      ((get-method p 'act) self))))

      (defmethod (eat-person person)
	(ask self 'say
	     (append '("Growl.... I'm going to eat you,")
		     (list (ask person 'name))))
	(go-to-heaven person)
	(ask self 'say
	     (append '("Chomp chomp.") (list (ask person 'name))
		     '("tastes yummy!")))
	'eaten)
      
      (else (get-method p message))))))

(define (go-to-heaven person)
  (for-each (lambda (item) (ask person 'lose item))
	    (ask person 'possessions))
  (ask person 'say '("It is a far, far, better place I go to!"))
  (ask person 'move-to heaven)
  (remove-from-clock-list person)
  'dead)


;;; Clock routines

(define *clock-list* '())

(define (initialize-clock-list)
  (set! *clock-list* '())
  'initialized)

(define (add-to-clock-list person)
  (set! *clock-list* (cons person *clock-list*))
  'added)

(define (remove-from-clock-list person)
  (set! *clock-list* (delq person *clock-list*))
  'removed)

(define (clock)
   (for-each (lambda (person) (ask person 'move))
	     *clock-list*))
	     

(define (run-clock n)
  (if (= n 0)
      'done
      (sequence (clock) (run-clock (- n 1)))))

;;; Some generally useful procedures

(define (is-a object type)
  (let ((m (get-method object type)))
    (if (method? m)
	(ask object type)
	false)))

(define (install-person person)
    (ask (ask person 'place) 'appear person)
    (add-to-clock-list person)
    'installed)


(define (other-people-at-place person place)
  (filter (lambda (object)
	    (if (not (eq? object person))
		(is-a object 'person?)
		false))
	  (ask place 'things)))


(define (greet-people person people)
  (if (not (null? people))
      (ask person 'say
	   (append '("Hi")
		   (mapcar (lambda (p) (ask p 'name))
			   people)))))

(define (display-message list-of-stuff)
  (newline)
  (for-each (lambda (s) (princ s) (princ " "))
	    list-of-stuff))

(define (announce-move name old-place new-place)
  (display-message
   (list name "moves from" (ask old-place 'name)
	 "to" (ask new-place 'name))))


(define (random-place old-place)
  (pick-random (ask old-place 'neighbors)))

(define (filter predicate list)
  (cond ((null? list) '())
	((predicate (car list))
	 (cons (car list) (filter predicate (cdr list))))
	(else (filter predicate (cdr list)))))


(define (pick-random list)
  (if (null? list)
      '()
      (list-ref list (random (length list)))))

(define (delq item list)
  (cond ((null? list) '())
	((eq? item (car list)) (delq item (cdr list)))
	(else (cons (car list) (delq item (cdr list))))))


;;FOR-EACH is another (and preferred) name for the primitive
;;procedure MAPC

(define for-each mapc)

