;                         Solutions to Part 2


; EXERCISE 6

;  ==> (in-parallel? r1 r2 network-1)
;  () 
;  ==> (define net (make-net (list a b)
;         (list (connect r1 a b) (connect r2 a b))))
;  NET 
;  ==> (in-parallel? r1 r2 net)
;  T 

(define the-empty-set (make-set))

; Assuming connection-nodes returns a SET of nodes.

; (nodes part network)
;	part	A network part (resistor, capacitor, etc.)
;	network	A network
; Returns a set of all nodes in 'network' which are connected to 'part.'
;
; Works by computing a set of sets of connections to 'part' in the given
; network.  Then uses reduce-set to produce a set of nodes.
;
(define (nodes part network)
  (define (test-connection con)
    (if (eq? part (connection-part con))
	(connection-nodes con)
	the-empty-set))
  (reduce-set union-set
	      (map-set test-connection
		       (connections network))))

(define (equal-set? s1 s2)
  ; Returns T if s1 is the same set as s2
  (and (subset? s1 s2) (subset? s2 s1)))



; EXERCISE 7

;  ==> (in-series? r1 r2 network-1)
;  () 
;  ==> (in-series? r1 r2 network-2)
;  T 
;  ==> (in-series? r1 r2 net)
;  () 


(define (union-set s1 s2)
  ; Returns the union of s1 and s2
  (cond ((null? s1) s2)
        ((element-of-set? (car s1) s2)
	 (union-set (cdr s1) s2))
	(else (union-set (cdr s1)
			 (cons (car s1) s2)))))

(define (difference-set s1 s2)
  ; Returns the set of elements that are in s1 that
  ;   are not also in s2
  (define (search rest-of-s1 result)
    (cond ((null? rest-of-s1) result)
	  ((element-of-set? (car rest-of-s1) s2)
	   (search (cdr rest-of-s1) result))
	  (else (search (cdr rest-of-s1)
			(cons (car rest-of-s1) result)))))
  (search s1 '()))


(define (all-parts network)
  ; returns all of the parts in network
  ; we assume that a part is only used once in a network
  (mapcar connection-part (connections network)))

(define (map-set f s)
  ; returns a set that consists of 
  ; f applied to each element of set s
  (if (null? s) '()
      (union-set (make-set (f (car s)))
		 (map-set f (cdr s)))))

(define (singleton? set)
  ; returns T if set has a single member
  (= (length set) 1))


(define first car)
(define second cadr)


; Exercise 8

; The essential idea is to use wishful thinking
;   If the network is a single component, we are done
;   If not, see if we can combine two parts
;   If we can not combine two parts, then the circuit
;     can not be expressed in terms of make-parallel
;     and make-series


; Here is some example output:
;
;
; ==> (fsp network-1)
; () 
; ==> (fsp network-2)
; (PARALLEL-COMBINATION
;  (SERIES-COMBINATION (RESISTOR . 30) (RESISTOR . 40))
;  (PARALLEL-COMBINATION (SERIES-COMBINATION (RESISTOR . 10) (RESISTOR . 20)) (RESISTOR . 50))) 
;


(define (fsp network)
  ; find series parallel equivalent to network
  ; returns nil if it can't be done
  (if (singleton? (all-parts network))
      ; if a single part, we have won!
      (connection-part (car (connections network)))
      ; try to see if we can reduce the network by
      ; one part
      (reduce-net network)))

(define (reduce-net network)
  ; for all pairs of connections, see if we can find
  ; a series or a parallel combination
  (define (loop c1 c2)
    (cond ((null? c1) nil)
	  ((null? c2) (loop (cdr c1)
			    (connections network)))
	  ((eq? (car c1) (car c2))
	   ; don't compare a part against itself
	   (loop c1 (cdr c2)))
	  (else
	   (let ((p1 (connection-part (car c1)))
		 (p2 (connection-part (car c2))))
          (cond
	   ((in-series? p1 p2 network)
	    ; found two resistors in series
	    (fsp (make-net
		  (terminals network)
		  (adjoin-set
		   (connect
		    (make-series p1 p2)
		    (first (difference-set
			    (union-set
			     (connection-nodes (car c1))
			     (connection-nodes (car c2)))
			    (connection-nodes (car c2))))
		    (first (difference-set
			    (union-set
			     (connection-nodes (car c1))
			     (connection-nodes (car c2)))
			    (connection-nodes (car c1)))))
		    (difference-set
		     (connections network)
		     (make-set (car c1) (car c2)))))))
	   ((in-parallel? p1 p2 network)
	    ; found two resistors in parallel
	    (fsp (make-net
		  (terminals network)
		  (adjoin-set
		   (connect
		    (make-parallel p1 p2)
		    (first (connection-nodes (car c1)))
		    (second (connection-nodes (car c1))))
		   (difference-set
		    (connections network)
		    (make-set (car c1) (car c2)))))))
	   ; these two parts were not in series or parallel
	   ; keep looking
	   (else (loop c1 (cdr c2))))))))
  ; start the loop up
  (loop (connections network) (connections network)))
