;;; This is the file PS5-SETS.SCM.  Sets are represented as 
;;;  unordered lists of their elements, similar to section 2.2.5
;;;  of the text.

(define empty-set? null?)

(define make-set list)

(define (singleton? set) (null? (cdr set)))

(define (element-of-set? x set)
  (cond ((null? set) nil)
	((eq? x (car set)) t)
	(else (element-of-set? x (cdr set)))))

(define (adjoin-set x set)
  (if (element-of-set? x set)
      set
      (cons x set)))


(define (subset? set1 set2)
  (cond ((null? set1) t)
	((element-of-set? (car set1) set2)
	 (subset? (cdr set1) set2))
	(else nil)))

(define (intersection-set set1 set2)
  (cond ((or (null? set1) (null? set2)) '())
	((element-of-set? (car set1) set2)
	 (cons (car set1)
	       (intersection-set (cdr set1) set2)))
	(else (intersection-set (cdr set1) set2))))


;;; Missing procedures:  EQUAL-SET?, UNION-SET, DIFFERENCE-SET.
;;;  (EQUAL-SET? SET1 SET2) determines if the two given sets have
;;;     exactly the same elements.
;;;  (UNION-SET SET1 SET2) produces the set of elements that are 
;;;     in either of the given sets (or both).
;;;  (DIFFERENCE-SET SET1 SET2) produces the set of elements of 
;;;     SET1 that are not also in SET2.


;;; Set iterators

(define (reduce-set f set)
  (define (iter s)
    (if (singleton? s)
	(car s)
	(iter (adjoin-set (f (car s) (cadr s))
			  (cddr s)))))
  (if (null? set) '() (iter set)))

;;; Missing iterators: MAP-SET 
;;;  (MAP-SET PROCEDURE SET) should take a procedure and
;;;    a set and produce the set of results of applying the
;;;    given procedure to the elements of the given set.
