(define (draw-line x1 y1 x2 y2)
  (position-pen x1 y1)
  (draw-line-to x2 y2))

(define (c-curve x1 y1 x2 y2 n)
  (define (break-line xm ym)
    (c-curve x1 y1 xm ym (- n 1))
    (c-curve xm ym x2 y2 (- n 1)))
  (if (= n 0)
      (draw-line x1 y1 x2 y2)
      (break-line (/ (- (+ x2 x1 y1) y2) 2)
		  (/ (- (+ x2 y1 y2) x1) 2))))



(define (length-line x1 y1 x2 y2)
  (define (sq x) (* x x))
  (sqrt (+ (sq (- x2 x1)) (sq (- y2 y1)))))

(define (lc-curve x1 y1 x2 y2 n)
  (define (break-line xm ym)
    (+ (lc-curve x1 y1 xm ym (- n 1))
       (lc-curve xm ym x2 y2 (- n 1))))
  (if (= n 0)
      (length-line x1 y1 x2 y2)
      (break-line (/ (- (+ x2 x1 y1) y2) 2)
		  (/ (- (+ x2 y1 y2) x1) 2))))
		  