(define (n-paths level bin)
  (if (>= level bin 0)
      (if (= level 0)
	  1
	  (+ (n-paths (- level 1) (- bin 1))
	     (n-paths (- level 1) bin)))
      0))

(define (c n k)
  (/ (fact n)
     (* (fact (- n k))
	(fact k))))

(define (fact n)
  (if (= n 0)
      1
      (* n (fact (- n 1)))))

(define (smooth f)
  (let ((h (/ dx 2)))
    (lambda (x)
      (average (f (- x h))
	       (f (+ x h))))))

(define (average x y)
  (/ (+ x y) 2))

(define (repeated n f)
  (if (= n 0)
      identity
      (compose f (repeated (- n 1) f))))

(define (identity x) x)

(define (compose f g)
  (lambda (x) (f (g x))))

(define (nth-smooth n f dx)
  (let ((h (/ dx 2))
	(scale (expt 2 n)))
    (lambda (x)
      (define (loop i ans)
	(if (> i n)
	    (/ ans scale)
	    (loop (+ i 1)
		  (+ (* (expt -1 (- n i))
			(c n i)
			(f (+ x (* h (- (* 2 i) n)))))
		     ans))))
      (loop 0 0))))
  