
(define (analyze exp)
  (cond ((self-evaluating? exp) (analyze-self-evaluating exp))
	((quoted? exp) (analyze-quoted exp))
	((variable? exp) (analyze-variable exp))
	((assignment? exp) (analyze-assignment exp))
	((definition? exp) (analyze-definition exp))
	((if? exp) (analyze-if exp))
	((lambda? exp) (analyze-lambda exp))
	((begin? exp) (analyze-sequence (begin-actions exp)))
	((amb? exp) (analyze-amb exp))
	((cond? exp) (analyze (COND->IF exp)))
	((let? exp) (analyze (LET->combination exp)))
	((permanent-set? exp)
	 (analyze-permanent-set exp))
	((if-fail? exp)
	 (analyze-if-fail exp))
	((application? exp) (analyze-application exp))
	(else
	 (error "Unknown expression type -- ANALYZE" exp))))

(define (permanent-set? exp)
  (tagged-list? exp 'permanent-set!))

(define (if-fail? exp)
  (tagged-list? exp 'if-fail))

(define (monitored-expression exp)
  (cadr exp))

(define (if-fail-consequent exp)
  (caddr exp))  



(define (analyze-permanent-set exp)
  (let ((var (assignment-variable exp))
	(vproc (analyze (assignment-value exp))))
    (lambda (env succeed fail)
      (vproc env
	     (lambda (val fail)
	       (set-variable-value! var val env)
	       (succeed 'done fail))
	     fail))))

(define (analyze-if-fail exp)
  (let ((m (analyze (monitored-expression exp)))
	(c (analyze (if-fail-consequent exp))))
    (lambda (env succeed fail)
      (m env
	 succeed
	 (lambda ()
	   (c env
	      succeed
	      fail))))))
