;;; top.s  

;;; boot loader for SPS
;;; Thu Nov 10 14:49:52 1988

(define spsdir "/u2/csfaculty/wand/sps/new/")

(define sps-version "1.6.01 (25 March 1993)")

(define sload
  (lambda (name)
    (load (string-append spsdir name))))

(display (string-append
           "SPS Version "
           sps-version 
           (string #\newline)))

(sload "chez-support.s")			; chez scheme specific
					; functions.

(sload "data-structures.s")		; definitions of data
					; structures, etc.

(sload "mgu.s")				; the unifier

(sload "check-exp.s")			; the basic typechecking algorithm.

(sload "defining-forms.s")		; define-checked, etc.

(sload "type-constructors.s")		; define-record-type,
					; define-type-constructor.

(sload "globals.s")			; types for Scheme globals and
					; standard constructors


(sload "scanner.s")                      ; interpreter for lexical
					; scanners

(sload "ll-parsers.s")                   ; LL parser generator and
					; interpreter

(sload "grammars.s")                     ; define-grammar,
					; define-unchecked-grammar. 


