;;; Changed access to *access. -- satish Feb 19 1993. 
;;; From mm@cacs.usl.edu Mon May 20 11:21:04 1991
;;; Return-Path: <mm@cacs.usl.edu>
;;; Date: Mon, 20 May 91 10:06:35 -0500
;;; From: mm@cacs.usl.edu (Margaret Montenyohl)
;;; To: wand@corwin.CCS.Northeastern.EDU
;;; Subject: mit-support.s

;;; This file contains definitions needed to run SPS in Cscheme. 
;;; In general, the changes involved 
;;; 1. Simple things like renaming functions and implementing property
;;;    lists
;;; 2. defining extend-syntax, record-case and various macros (this was hard)
;;; 3. Fixing format (this required editing Mitch's code for SPS)
;;;  ewe, 7/8/89
;;; 4. Also, Mitch's code was changed to produce only uppercase identifiers, 
;;; see files for parser


;;; Renaming Chez functions to comparable Cscheme functions

(define call/cc call-with-current-continuation)
(define pretty-print pp)
(define rest cdr)
(define nil ())
(define gensym generate-uninterned-symbol)
(define reset (lambda () (error "SPS system reset!")))

;;; Adding definitions used in SPS but not found in CScheme

(define atom?
  (lambda (x)
  (not (pair? x))))

(define writeln
  (lambda l
    (begin
      (newline)
      (for-each display l)
      (newline))))

(define 1- (lambda (x) (- x 1)))

;;; Additions for set!
;;; The following defines are necessary because in mitscheme, you can't
;;; set! an identifier until it has been defined. 

(define table-2)     ;;; for grammars.s
(define scanner-2)   ;;; for grammars.s
(define automaton-2) ;;; for grammars.s

;;;Property Lists
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The following procedures were written by bwr to support property
;;;  lists in CScheme

(define make-table
  (lambda ()
    (list '*table*)))

(define lookup-table
  (lambda (key table)
    (let ((record (assq key (rest table))))
      (if  record
	   (cdr record)
           #f))))

(define insert-table!
  (lambda (key value table)
    (let ((record (assq key (rest table))))
      (if record
	  (set-cdr! record value)
	  (set-cdr! table (cons (cons key value) (rest table)))))))


(define *property-list* (make-table))

(define getprop
  (lambda (name property)
    (let ((plist (lookup-table name *property-list*)))
      (if plist
	  (lookup-table property plist)
	  #f))))

(define putprop
  (lambda (name property value)
    (let ((plist (lookup-table name *property-list*)))
      (if plist
	  (insert-table! property value plist)
	  (begin
	    (insert-table! name (make-table) *property-list*)
	    (insert-table! property value (lookup-table name *property-list*)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;; SPS can handle only one syntactic extension (let) 
;;; (see function checker-body) in mgu.s
;;; this is a quick fix that should be improved later 
;;; but works fine for our purposes

(define *syntactic-extensions* '(let))
 
(define syntactic-extension?
  (lambda (name)
    (memq name *syntactic-extensions*)))
 
(define expand-once
  (lambda (form)
    (define expand-let
      (lambda (form)
        (cons (cons 'lambda
                    (cons (map first (second form)) ;; mapcar to map.
					;; sv -- 3/2/93 
                          (cddr form)))
              (map second (second form))))) ;; mapcar to map 
					;; sv -- 3/2/93 
    (if (eq? (first form) 'let)
        (expand-let form)
        form)))



(syntax-table-define system-global-syntax-table 'define-global-macro
  (macro (args . body)
    (let ((name (car args))
	  (formals (cdr args)))
    `(begin
       (syntax-table-define system-global-syntax-table ',name
	 (macro ,formals
	   ,@body))
       ',name))))


(define-global-macro (expand-macro macro-call)
  `(unsyntax (syntax ',macro-call (rep-syntax-table))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Now load in Kent Dybvig's extend-syntax code
 
;;; extend-syntax.scm    --  August 7, 1989   --- ewe
;;; Ported from Chez to Cscheme.
;;; Additions include
;;;  new macros for when, unless, and kerror 
;;; ('kerror' to differentiate from mitscheme's 'error' function.)
;;; new functions were added: gensym, duplicate-symbols, box, unbox, set-box!.

;;; We modified Kent's original code as follows:
;;;	. All 'defines' were nested inside the definition of extend-syntax.
;;;	. Syntax-Match? had to be defined local to extend-syntax's definition
;;;       and local to the call to define-macro that appears in the 
;;;	  expansion for extend-syntax. (see bottom of file).


;;; 156 through 561 deleted to mit-support.deleted
;;; extend-syntax.scm
;;; August 7, 1989
;;; Ported from chez to mitscheme M. Radle, M. Montenyohl and E. Elberson
;;; new macros include:  when, unless,  and
;;; kerror ('k' to differentiate from mitscheme's 'error' function.)
;;; The following functions were added:
;;;  gensym, duplicate-symbols, box, unbox, set-box!.
;;; April 15, 1991 (markf@zurich.ai.mit.edu)
;;; Added define-macro-both to define macros in this file and in
;;; user-initial-syntax-table.

(syntax-table-define user-initial-syntax-table 'define-macro-both
  (macro (pattern . body)
    `(begin
       (define-macro ,pattern ,@body)
       (syntax-table-define user-initial-syntax-table ',(car pattern)
	 (macro ,(cdr pattern)
	   ,@body)))))

(define-macro (define-macro-both pattern . body)
  `(begin
     (define-macro ,pattern ,@body)
     (syntax-table-define user-initial-syntax-table ',(car pattern)
       (macro ,(cdr pattern)
	 ,@body))))

(define gensym generate-uninterned-symbol)

(define gensym generate-uninterned-symbol)

(define-macro-both (unless *cond . e1 ) `(if (not ,*cond) (begin ,@e1) #f))

(define-macro-both (when *cond . e1) `(if ,*cond (begin ,@e1) #f))

'(define-macro (kerror msg-line . args)
  `(begin
     (format #T ,msg-line ,@args) ;; -- sv 3/15/93 
     (error " ")))

;; kerror defined as procedure. define-macro doesn't seem to do the job.
;; This is a quick hack and should be looked into later. -- sv 3/15/93
(define kerror 
  (lambda (msg-line #!rest args)
  (begin
     (format #T msg-line args) ;; -- sv 3/15/93 
     (error " "))))


;;; extend.ss
;;; Copyright (C) 1987 R. Kent Dybvig
;;; Permission to copy this software, in whole or in part, to use this
;;; software for any lawful purpose, and to redistribute this software
;;; is granted subject to the restriction that all copies made of this
;;; software must include this copyright notice in full.
 
;;; The basic design of extend-syntax is due to Eugene Kohlbecker.  See
;;; "E. Kohlbecker: Syntactic Extensions in the Programming Language Lisp",
;;; Ph.D.  Dissertation, Indiana University, 1986."  The structure of "with"
;;; pattern/value clauses, the method for compiling extend-syntax into
;;; Scheme code, and the actual implementation are due to Kent Dybvig.


;;; August 7, 1989
;;; We modified Kent's original code as follows:
;;;     . use define-macro to define extend-syntax
;;;	. All 'defines' are nested inside the definition of extend-syntax.
;;;	. Syntax-Match? had to be defined local to extend-syntax's definition
;;;       and local to the call to define-macro that appears in the 
;;;	  expansion for extend-syntax. (see bottom of file).
;;; April 15, 1991 (markf@zurich.ai.mit.edu)
;;; Use syntax-table-define instead of define-macro.
;;; Put syntax-match in the proper place.

(syntax-table-define user-initial-syntax-table 'extend-syntax
  (macro (keys . clauses)

    (define gensym generate-uninterned-symbol)
    (define box (lambda (x) (cons x #f)))
    (define unbox (lambda (x) (car x)))
    (define set-box! (lambda (x v) (set-car! x v)))
    
    (define duplicate-symbols
      (lambda ( list )
	(unless (null? list)
		(when (memq (car list) (cdr list))
		      (cons (car list)
			    ( duplicate-symbols (cdr list)))))))
 
 

    (define id
      (lambda (name *access control)
	(list name *access control)))
    (define id-name car)
    (define id-access cadr)
    (define id-control caddr)

    (define loop
      (lambda ()
	(box '())))
    (define loop-ids unbox)
    (define loop-ids! set-box!)

    (define c...rs
      `((car caar . cdar)
        (cdr cadr . cddr)
        (caar caaar . cdaar)
        (cadr caadr . cdadr)
        (cdar cadar . cddar)
        (cddr caddr . cdddr)
        (caaar caaaar . cdaaar)
        (caadr caaadr . cdaadr)
        (cadar caadar . cdadar)
        (caddr caaddr . cdaddr)
        (cdaar cadaar . cddaar)
        (cdadr cadadr . cddadr)
        (cddar caddar . cdddar)
        (cdddr cadddr . cddddr)))

    (define add-car
      (lambda (*access)
	(let ((x (and (pair? *access) (assq (car *access) c...rs))))
	  (if (null? x)
	      `(car ,*access)
	      `(,(cadr x) ,@(cdr *access))))))

    (define add-cdr
      (lambda (*access)
	(let ((x (and (pair? *access) (assq (car *access) c...rs))))
	  (if (null? x)
	      `(cdr ,*access)
	      `(,(cddr x) ,@(cdr *access))))))


    (define checkpat
      (lambda (keys pat exp)
	(let ((vars (let f ((x pat) (vars '()))
		      (cond
		       ((pair? x)
			(if (and (pair? (cdr x))
				 (eq? (cadr x) '...)
				 (null? (cddr x)))
			    (f (car x) vars)
			    (f (car x) (f (cdr x) vars))))
		       ((symbol? x)
			(cond
			 ((memq x keys) vars)
			 ((or (eq? x 'with) (eq? x '...))
			  (kerror
			   "EXTEND-SYNTAX: Invalid context for ~s in ~s" ;; sv 3/15/93
			   x exp))
			 (else (cons x vars))))
		       (else vars)))))
	  (let ((dupls (duplicate-symbols vars)))
	    (unless (null? dupls)
		    (kerror "EXTEND-SYNTAX: duplicate pattern variable name ~s in ~s"
			    (car dupls) exp)))))) ;; -- sv 3/15/93

    (define parse
      (lambda (keys pat acc cntl ids)
	(cond
	 ((symbol? pat)
	  (if (memq pat keys)
	      ids
	      (cons (id pat acc cntl) ids)))
	 ((pair? pat)
	  (cons (id pat acc cntl)
		(if (equal? (cdr pat) '(...))
		    (let ((x (gensym)))
		      (parse keys (car pat) x (id x acc cntl) ids))
		    (parse keys (car pat) (add-car acc) cntl
			   (parse keys (cdr pat) (add-cdr acc) cntl ids)))))
	 (else ids))))

    (define pattern-variable?
      (lambda (sym ids)
	(memq sym (map id-name ids))))

    (define gen
      (lambda (keys exp ids loops qqlev)
	(cond
	 ((lookup exp ids) =>
			   (lambda (id)
			     (add-control! (id-control id) loops)
			     (list 'unquote (id-access id))))
	 ((not (pair? exp)) exp)
	 (else
	  (cond
	   ((and (syntax-match? '(quasiquote *) exp)
		 (not (pattern-variable? 'quasiqote ids)))
	    (list 'unquote
		  (list 'list
			''quasiquote
			(make-quasi
			 (gen keys (cadr exp) ids loops
			      (if (= qqlev 0) 0 (+ qqlev 1)))))))
	   ((and (syntax-match? '(* *) exp)
		 (memq (car exp) '(unquote unquote-splicing))
		 (not (pattern-variable? (car exp) ids)))
	    (list 'unquote
		  (list 'list
			(list 'quote (car exp))
			(make-quasi
			 (if (= qqlev 1)
			     (gen-quotes keys (cadr exp) ids loops)
			     (gen keys (cadr exp) ids loops
				  (- qqlev 1)))))))
	   ((and (eq? (car exp) 'with)
		 (not (pattern-variable? 'with ids)))
	    (unless (syntax-match? '(with ((* *) ...) *) exp)
                    (kerror "EXTEND-SYNTAX: invalid 'with' form ~s" exp))
		;; -- sv 3/15/93
	    (checkpat keys (map car (cadr exp)) exp) 
	    (list 'unquote
		  (gen-with
		   keys
		   (map car (cadr exp))
		   (map cadr (cadr exp))
		   (caddr exp)
		   ids
		   loops)))
	   ((and (pair? (cdr exp)) (eq? (cadr exp) '...))
	    (let ((x (loop)))
	      (gen-cons (list 'unquote-splicing
			      (make-loop x (gen keys (car exp) ids
						(cons x loops) qqlev)))
			(gen keys (cddr exp) ids loops qqlev))))
	   (else
	    (gen-cons (gen keys (car exp) ids loops qqlev)
		      (gen keys (cdr exp) ids loops qqlev))))))))

    (define gen-cons
      (lambda (head tail)
	(if (null? tail)
	    (if (syntax-match? '(unquote-splicing *) head)
		(list 'unquote (cadr head))
		(cons head tail))
	    (if (syntax-match? '(unquote *) tail)
		(list head (list 'unquote-splicing (cadr tail)))
		(cons head tail)))))

    (define gen-with
      (lambda (keys pats exps body ids loops)
	(let ((temps (map (lambda (x) (gensym)) pats)))
	  `(let (,@(map (lambda (t e) `(,t ,(gen-quotes keys e ids loops)))
			temps
			exps))
	     ,@(let f ((pats pats) (temps temps))
		 (if (null? pats)
		     '()
		     (let ((m (match-pattern '() (car pats)))
			   (rest (f (cdr pats) (cdr temps))))
		       (if (eq? m '*)
			   (f (cdr pats) (cdr temps))
			   `((unless (syntax-match? ',m ,(car temps))
                                     (kerror "~s: ~s does not fit 'with' pattern ~s" ;; -- sv 3/15/93 
					     ',(car keys)
					     ,(car temps)
					     ',(car pats)))
			     ,@(f (cdr pats) (cdr temps)))))))
	     ,(let f ((pats pats) (temps temps) (ids ids))
		(if (null? pats)
		    (make-quasi (gen keys body ids loops 0))
		    (f (cdr pats)
		       (cdr temps)
		       (parse '() (car pats) (car temps) '() ids))))))))

    (define gen-quotes
      (lambda (keys exp ids loops)
	(cond
	 ((syntax-match? '(quote *) exp)
	  (make-quasi (gen keys (cadr exp) ids loops 0)))
	 ((syntax-match? '(quasiquote *) exp)
	  (make-quasi (gen keys (cadr exp) ids loops 1)))
	 ((pair? exp)
	  (let f ((exp exp))
	    (if (pair? exp)
		(cons (gen-quotes keys (car exp) ids loops)
		      (f (cdr exp)))
		(gen-quotes keys exp ids loops))))
	 (else exp))))

    (define lookup
      (lambda (exp ids)
	(let loop ((ls ids))
	  (cond
	   ((null? ls) #f)
	   ((equal? (id-name (car ls)) exp) (car ls))
	   ((subexp? (id-name (car ls)) exp) #f)
	   (else (loop (cdr ls)))))))

    (define subexp?
      (lambda (exp1 exp2)
	(and (symbol? exp1)
	     (let f ((exp2 exp2))
	       (or (eq? exp1 exp2)
		   (and (pair? exp2)
			(or (f (car exp2))
			    (f (cdr exp2)))))))))

    (define add-control!
      (lambda (id loops)
	(unless (null? id)
		(when (null? loops)
		      (kerror "EXTEND-SYNTAX: missing ellipsis in expansion"))
		(let ((x (loop-ids (car loops))))
		  (unless (memq id x)
			  (loop-ids! (car loops) (cons id x))))
		(add-control! (id-control id) (cdr loops)))))

    (define make-loop
      (lambda (loop body)
	(let ((ids (loop-ids loop)))
	  (when (null? ids)
		(kerror "EXTEND-SYNTAX: extra ellipsis in expansion"))
	  (cond
	   ((equal? body (list 'unquote (id-name (car ids))))
	    (id-access (car ids)))
	   ((and (null? (cdr ids))
		 (syntax-match? '(unquote (* *)) body)
		 (eq? (cadadr body) (id-name (car ids))))
	    `(map ,(caadr body) ,(id-access (car ids))))
	   (else
	    `(map (lambda ,(map id-name ids) ,(make-quasi body))
		  ,@(map id-access ids)))))))

    (define match-pattern
      (lambda (keys pat)
	(cond
	 ((symbol? pat)
	  (if (memq pat keys)
	      (if (memq pat '(* \\ ...))
		  `(\\ ,pat)
		  pat)
	      '*))
	 ((pair? pat)
	  (if (and (pair? (cdr pat))
		   (eq? (cadr pat) '...)
		   (null? (cddr pat)))
	      `(,(match-pattern keys (car pat)) ...)
	      (cons (match-pattern keys (car pat))
		    (match-pattern keys (cdr pat)))))
	 (else pat))))
         
    (define make-quasi
      (lambda (exp)
	(if (and (pair? exp) (eq? (car exp) 'unquote))
	    (cadr exp)
	    (list 'quasiquote exp))))




    (define make-clause
      (lambda (keys cl x)
	(cond
	 ((syntax-match? '(* * *) cl)
	  (let ((pat (car cl)) (fender (cadr cl)) (exp (caddr cl)))
	    (checkpat keys pat pat)
	    (let ((ids (parse keys pat x '() '())))
	      `((and (syntax-match? ',(match-pattern keys pat) ,x)
		     ,(gen-quotes keys fender ids '()))
		,(make-quasi (gen keys exp ids '() 0))))))
	 ((syntax-match? '(* *) cl)
	  (let ((pat (car cl)) (exp (cadr cl)))
	    (checkpat keys pat pat)
	    (let ((ids (parse keys pat x '() '())))
	      `((syntax-match? ',(match-pattern keys pat) ,x)
		,(make-quasi (gen keys exp ids '() 0))))))
	 (else
	  (kerror "EXTEND-SYNTAX: invalid clause ~s" cl))))) ;; -sv 3/15/93

    (define make-syntax
      (let ((x (string->uninterned-symbol "x")))
	(lambda (keys clauses)
	  (when (memq '... keys)
		(kerror "EXTEND-SYNTAX: invalid keyword ... in keyword list ~s"
			keys)) ;; -- sv 3/15/93 
	  `(lambda (,x)
	     (cond
	      ,@(map (lambda (cl) (make-clause keys cl x)) clauses)
	      (else
	       (kerror "~s: invalid syntax ~s" ',(car keys) ,x)))
	     )))) ;; --sv 3/15/93 



    `(define-macro-both (,(car keys) . body)

       (,(make-syntax keys clauses)  (cons ',(car keys) body)))))



(define syntax-match?
   (lambda (pat exp)
      (or (eq? pat '*)
          (eq? exp pat)
          (and (pair? pat)
               (cond
                  ((and (eq? (car pat) '\\)
                        (pair? (cdr pat))
                        (null? (cddr pat)))
                   (eq? exp (cadr pat)))
                  ((and (pair? (cdr pat))
                        (eq? (cadr pat) '...)
                        (null? (cddr pat)))
                   (let ((pat (car pat)))
                      (let f ((lst exp))
                         (or (null? lst)
                             (and (pair? lst)
                                  (syntax-match? pat (car lst))
                                  (f (cdr lst)))))))
                  (else
                   (and (pair? exp)
                        (syntax-match? (car pat) (car exp))
                        (syntax-match? (cdr pat) (cdr exp)))))))))
 
 
(local-assignment syntaxer/default-environment
		  'syntax-match?
		  syntax-match?)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;end of extend-syntax

;;;define rec for Csheme (see page 58 of Dyvbig's book)
(extend-syntax (rec) 
   ((rec x v) (letrec ((x v)) x)))

;;; This implementation of printf simply changes any ~s in a string to
;;; a ~o. It isn't intended to function as the Chez Scheme printf.
;;; The only format characters that are used
;;; with printf inside of SPS are ~s and ~% (newline). Mitscheme has
;;; format, which is similar to printf, but ~s needs to be ~o. It can
;;; handle the ~%'s.
;;; ewe august 89

(define (s-to-o string)
   (subst-o-for-s string 0))

(define (subst-o-for-s string strpos)
   (let ((current-length (string-length string))
         (nextpos (+ 1 strpos)))
      (cond ((>= strpos current-length) string)
            ((char=? (string-ref string strpos) #\~)
             (if (and (< nextpos current-length)
                      (char=? (string-ref string nextpos) #\s))
                (begin
                   (string-set! string nextpos #\s) ;\o -> \s --sv
                   (subst-o-for-s string (+ 1 nextpos)))
                (subst-o-for-s string nextpos)))
            (else (subst-o-for-s string (+ 1 strpos)))
      )
   )
)

(extend-syntax (printf)
   ((printf string arg ...)
    (with ((newstring (s-to-o 'string)))
       (format #t newstring arg ...))))  ;; MIT Scheme supports ~s -sv 2/22/93. added #t symbol 
       ; (format newstring arg ...)))) ; original distr code.

;;; The error function in Chez works differently than error in Cscheme.
;;; All calls to error in SPS are changed to chez-error and the macro defined
;;; below simulates the error function in Chez. The macro call takes
;;; a literal (usually the name of the caller),
;;; a printf-style error message,
;;; and any number of  arguments for that error message. 

(extend-syntax (chez-error)
   ((chez-error error-loc errmsg arg ...)
    (begin
       (printf "Error in ~s: " error-loc)
       (printf errmsg arg ...)
       (error " "))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; The following code is our implementation of record-case. We got most
;;; of this code (almost all of it) from Appendix A of 
;;; Programming Languages  Abstraction, Representation and Implemenation
;;; by Friedman, Wand, Kohlebecher, and Haynes


(define record-proc-names
	(lambda ( name fields )
		(let ((name-str (symbol->string name)))
		   (cons (string->symbol (string-append "MAKE-" name-str))
			(cons (string->symbol (string-append name-str "?"))
			   (map (lambda (field)
				(string->symbol (string-append name-str "->"
					(symbol->string field))))
			    fields))))))



(define record-indices
	(lambda (vec-len)
	   (letrec (( loop (lambda (i)
			(if (= i vec-len)
			    '()
			    (cons i (loop (+ i 1)))))))
	      (loop 1))))



(extend-syntax (def-rec)
	((def-rec name (field ...))
	  (with (((make-name name? name->field ...)
		  (record-proc-names 'name '(field ...)))
		(vec-len (+ 1 (length '(field ...)))))
	  (with (((i ...) (record-indices 'vec-len)))
	    (begin
		(define make-name
		  (lambda (field ...)
		     (vector 'name field ...)))
		(define name?
		  (lambda (obj)
		     (and (vector? obj)
			  (= (vector-length obj) vec-len)
			  (eq? (vector-ref obj 0) 'name))))
		(define name->field
		  (lambda (obj)
		     (if (name? obj)
			 (vector-ref obj i)
			 (error "name->field: bad record" obj))))
		...
		'name)))))



(extend-syntax (record-case else)
	((record-case var)
 	 (error "record-case: no clause matches" var))
	((record-case var (else e1 e2 ...))
	 (begin e1 e2 ...))
	((record-case exp1 clause ...)
	 (not (symbol? 'exp1))
	 (with ((var (gensym)))
	    (let ((var  exp1))
		(record-case var clause ...))))
	((record-case var (name (field ...) exp1 exp2 ...) clause ...)
	 (with (((make-name name? name->field ... )
	 	 (record-proc-names 'name '(field ...)))
                 (new-var (gensym)))
           (let ((new-var (list->vector var)))
           (begin 
                  (def-rec name (field ...))
	          (if (name? new-var)
	              (let ((field (name->field new-var)) ...)
		       exp1 exp2 ...)
	              (record-case var clause ...)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;code from chez-support.s

;;; Auxiliary functions for simulating random Scheme84 calls in Chez
;;; Scheme


(define (ptime) (list (gctime) 0))		; 2nd component should
						; be gc-time.

(define checker-time 0)

(define mgu-time (cons 0 nil))

(define ctime
  (lambda ()
    (append (ptime) (list checker-time (car mgu-time)))))


(define report-error
  (lambda (msg)
    (pretty-print msg)
    (reset)))

(define gen-fcn-sym gensym)







