;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1989, 1990, 1991, 1992 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

;;; See Template.scm in the Scheme Library for how to set up
;;; vicinities and require.

(load (in-vicinity (program-vicinity) "scl.scm"))
			;Common Lisp/Scheme compatability definitions.
(load (in-vicinity (program-vicinity) "toploads"))

;;;; error and interrupt response for SCM.
;;; Put appropriate handlers for other systems here.

(define (impl_error str)
  (force-output)
  (newline-diag)
  (perror "ERROR")
  (set-errno 0)
  (display-diag str)
  (display-diag "; Last expression lost.")
  (newline-diag)
  (force-output)
  (math_exit #f))			;return to math top level.

;;;; These are error handlers for SCM.
(define out-of-storage #f)
(define could-not-open #f)
(define arithmetic-error #f)
(define user-interrupt #f)
(define end-of-program #f)
;(define hang-up end-of-program)		;automatic

(define (set-handlers!)
  (set! out-of-storage (lambda () (impl_error "Out of storage")))
  (set! could-not-open (lambda () (impl_error "File not found")))
  (set! arithmetic-error (lambda () (impl_error "Arithmetic Error")))
;  (set! user-interrupt (lambda () (impl_error "User Interrupt")))
  (set! end-of-program (lambda () (math_exit #t))))

(define (cleanup-handlers!)
  (set! out-of-storage #f)
  (set! could-not-open #f)
  (set! arithmetic-error #f)
  (set! user-interrupt #f)
  (set! end-of-program #f))
