;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1990, 1992 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

;;; This section deals with the user session protocol.

;;; The user can specify a line number prototype or the default can be
;;; used.  set prompt <legal identifier> sets the prototype.
;;; Subsequent unnumbered lines are assigned labels identical to the
;;; prototype except that the last field (consecutive alphabetic or
;;; consecutive numeric characters) is a unique field of the same type
;;; as the field.

;;; Equations can be referenced by their line numbers by operators
;;; which use equations.  Equations given as arguments to functions
;;; generate an error.  If the line number of an expression is given
;;; as an argument to an operator, @ = expression is the equation
;;; actually used.

;;; JACAL maintains a data base of equations and line numbers.  Each
;;; equation is associated with its line number.  The line number of
;;; each expression is associated with <line number> = expression.
;;; Each equation in the data base expresses a fact relating variables
;;; to each other.  Equations can be removed from the data base by the
;;; command dismiss(<line number>);.

;;; When a symbol which is a line number is used in an expression or
;;; as an argument to a function, the database is searched for an
;;; equation referencing that symbol.  One of those equations is used
;;; to eliminate variables or simplify the expression.
