;; -*- Scheme -*-
;;
;; $Id: avl-trie04.scm,v 1.1 1993/12/04 16:50:16 bevan Exp $

;;-----------

(require 'avl-trie::node:key)
(require 'avl-trie::node:kids)
(require 'avl-trie::node:value)
(require 'avl-tree:for-all-in-order)

;;-----------

;;+doc
;; procedure: avl-trie:flatten
;; arguments: trie undefined?
;; signature: trie[a,b] x (b -> bool) -> ?
;;
;; Flatten TRIE down into a list of lists.  The order of the lists is 
;; undefined.
;;
;; >(avl-trie:flatten 
;;   (avl-trie:insert 
;;    (avl-trie:insert (avl-trie:empty) '(1 2 3) (lambda () "x") < (lambda (o) "x") #f)
;;    '(1 2) (lambda () "y") < (lambda (o) "y") #f)
;;   not)
;; ((1 2 . "y") (1 2 3 . "x"))
;;-doc

(define avl-trie:flatten
  (lambda (t u?)
    (avl-tree:for-all-in-order
     t
     (lambda (s k&v)
       (let ((k (avl-trie::node:key k&v)) (v (avl-trie::node:value k&v)))
	 (let* ((kids (avl-trie:flatten (avl-trie::node:kids k&v) u?))
		(parents (map (lambda (l) (cons k l)) kids)))
	   (append s (if (u? v) parents (cons (cons k v) parents))))))
     (lambda (s _) s)
     (list))))

;; eof
