;; -*- Scheme -*-
;;
;; $Id: avl-trie01.scm,v 1.1 1993/12/04 16:49:38 bevan Exp $

;;-----------

(define avl-trie::node:key (lambda (n) (vector-ref n 0)))

(define avl-trie::node:kids (lambda (n) (vector-ref n 1)))

(define avl-trie::node:value (lambda (n) (vector-ref n 2)))

(define avl-trie::node vector)

(define avl-trie::node:+kids
  (lambda (c n)
    (avl-trie::node (avl-trie::node:key n) c (avl-trie::node:value n))))

(define avl-trie::node:+value
  (lambda (k d n)
    (avl-trie::node k (avl-trie::node:kids n) d)))

;;-----------

;exports avl-trie::node:key
;exports avl-trie::node:kids
;exports avl-trie::node:value
;exports avl-trie::node:+key
;exports avl-trie::node:+kids
;exports avl-trie::node:+value

;; eof
