(define (ufcd:find-congruent-division prog descr)
  (define meta-confs #f)
  (define meta-confs-modified? #f)
  (define (collect-mc-prog!)
    (for-each
      (lambda (fundef)
        (let ((body (cadddr fundef))
              (pars (cadr fundef))
              (fname (car fundef)))
          (let ((%%8 (assq fname meta-confs)))
            (let ((res (cddr %%8)) (args (cadr %%8)))
              (collect-mc! body pars args)))))
      prog))
  (define (collect-mc! exp vn vv)
    (cond ((symbol? exp) #f)
          ((equal? (car exp) 'quote)
           (let ((exp (cadr exp))) #f))
          ((let ((fname_exp* (cdr exp)) (call? (car exp)))
             (memq call? '(call rcall)))
           (let ((fname_exp* (cdr exp)) (call? (car exp)))
             (let ((exp* (cdr fname_exp*))
                   (fname (car fname_exp*)))
               (collect-mc*! exp* vn vv)
               (update-mc! fname (abstract-eval* exp* vn vv)))))
          ((equal? (car exp) 'xcall)
           (let ((exp* (cddr exp)) (fname (cadr exp)))
             (collect-mc*! exp* vn vv)))
          (else
           (let ((exp* (cdr exp)) (op (car exp)))
             (collect-mc*! exp* vn vv)))))
  (define (collect-mc*! exp* vn vv)
    (for-each
      (lambda (exp) (collect-mc! exp vn vv))
      exp*))
  (define (abstract-eval exp vn vv)
    (cond ((symbol? exp) (lookup-variable exp vn vv))
          ((equal? (car exp) 'quote)
           (let ((exp (cadr exp))) 's))
          ((equal? (car exp) 'generalize)
           (let ((exp (cadr exp))) 'd))
          ((let ((fname_exp* (cdr exp)) (call? (car exp)))
             (memq call? '(call rcall)))
           (let ((fname_exp* (cdr exp)) (call? (car exp)))
             (let ((exp* (cdr fname_exp*))
                   (fname (car fname_exp*)))
               (let ((%%9 (assq fname meta-confs)))
                 (let ((fres (cddr %%9)) (fargs (cadr %%9))) fres)))))
          ((equal? (car exp) 'xcall)
           (let ((exp* (cddr exp)) (fname (cadr exp)))
             (lub-list (abstract-eval* exp* vn vv))))
          (else
           (let ((exp* (cdr exp)) (op (car exp)))
             (lub-list (abstract-eval* exp* vn vv))))))
  (define (abstract-eval* exp* vn vv)
    (map (lambda (exp) (abstract-eval exp vn vv))
         exp*))
  (define (lub ind1 ind2)
    (if (eq? ind1 'd) 'd ind2))
  (define (lub-list ind*)
    (if (memq 'd ind*) 'd 's))
  (define (initial-meta-confs prog)
    (map (lambda (fundef)
           (let ((fpars (cadr fundef)) (fname (car fundef)))
             `(,fname ,(map (lambda (par) 's) fpars) . s)))
         prog))
  (define (update-mc! fname args)
    (let ((%%10 (assq fname meta-confs)))
      (let ((fdescr %%10))
        (let ((res1 (cddr fdescr)) (args1 (cadr fdescr)))
          (let ((%%11 (map lub args args1)))
            (let ((lub-args %%11))
              (if (not (equal? lub-args args1))
                (begin
                  (set-cdr!
                    fdescr
                    `(,lub-args unquote (lub-list lub-args)))
                  (set! meta-confs-modified? #t)))))))))
  (define (lookup-variable vname vn vv)
    (if (and (null? vn) (null? vv))
      (error "Undefined variable: " vname)
      (let ((vrest (cdr vv))
            (vv (car vv))
            (nrest (cdr vn))
            (vn (car vn)))
        (if (eq? vname vn)
          vv
          (lookup-variable vname nrest vrest)))))
  (let ((prog-rest (cdr prog)) (fname (caar prog)))
    (set! meta-confs
      `((,fname ,descr unquote (lub-list descr))
        unquote
        (initial-meta-confs prog-rest))))
  (let recalc-mc! ()
    (display "*")
    (set! meta-confs-modified? #f)
    (collect-mc-prog!)
    (if meta-confs-modified? (recalc-mc!) meta-confs)))

