Object variableSubclass: #ATN
	instanceVariableNames: 'where object action statelist '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!ATN methodsFor: 'no messages'! !


Object subclass: #Garden
	instanceVariableNames: 'lawnform gridsize activeView jane flower rock gnome tree pond wateringcan nLparser amove apick sentence moveverbs articles nouns preps adverbs toverbs goverbs pickverbs putverbs anand theParser theATN listsentence '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!Garden methodsFor: 'initialisation'!
adddetails2
	| t1 |
	lawnform _ Form new extent:200 @ 200!
adddetails3
"draw the objects into the form and set up the lists of synonyms and instantiate variables etc."
	| t1 |
	jane _ Person create.
	jane topView: activeView.
	t1 _ Shapes apersonform.
	jane setshape: t1.
	jane positionat3: 4 and: 4.
	rock _ Inanimates new.
	rock topView: activeView.
	t1 _ Shapes arockform.
	rock setshape: t1.
	rock positionat3: 4 and: 3.
	flower _ Inanimates new.
	flower topView: activeView.
	t1 _ Shapes aflowerform.
	flower setshape: t1.
	flower positionat3: 2 and: 7.
	gnome _ Inanimates new.
	gnome topView: activeView.
	t1 _ Shapes agnomeform.
	gnome setshape: t1.
	gnome positionat3: 6 and: 3.
	tree _ Inanimates new.
	tree topView: activeView.
	t1 _ Shapes atreeform.
	tree setshape: t1.
	tree positionat3: 2 and: 2.
pond _ Inanimates new.
	pond topView: activeView.
	t1 _ Shapes apondform.
	pond setshape: t1.
	pond positionat3: 7 and: 7.
nLparser_Words create:self.
amove_MoveVerb create: self.
apick_PickVerb create: self.
anand_JoinVerb create: self.
moveverbs_OrderedCollection new.
moveverbs add: #move; add: #go.
articles_OrderedCollection new.
articles add: #a; add: #the.
nouns_OrderedCollection new.
nouns add: #gnome; add: #rock; add: #flower; add: #tree.
preps_OrderedCollection new.
preps add: #near; add: #beside;  add: #by; add: #to.
adverbs_OrderedCollection new.
adverbs add: #up; add:#down;add:#left;add:#right.
toverbs_OrderedCollection new.
toverbs add: #to; add:#towards.
goverbs_OrderedCollection new.
goverbs add:#walk; add:#go; add:#head.
pickverbs_OrderedCollection new.
pickverbs add: #pick; add:#grab; add: #lift; add:#get.
putverbs_OrderedCollection new.
putverbs add:#put; add:#drop.
theATN _ NPATN create: self.
theParser _ NLParser create: self.! !

!Garden methodsFor: 'access'!
activeView: t1 
	| t2 t3 t4 |
	activeView _ t1!
Adverbs
	"comment stating purpose of message"

	| temporary variable names |
	^adverbs
!
Anand
	"comment stating purpose of message"

	| temporary variable names |
	^anand!
Aparser
	"comment stating purpose of message"

	| temporary variable names |
	^nLparser!
ArcType: anArc
	"what type of arc is this?"


	^anArc first!
Articles
	"comment stating purpose of message"

	| temporary variable names |
	^articles
!
Cat: anArc
	"returns true if this is a Category arc, false otherwise"


	((self ArcType: anArc) = #cat)
	ifTrue: [^true]
	ifFalse: [^false]!
Flower
	"comment stating purpose of message"

	| temporary variable names |
	^flower!
GetNextState: anArc
	"find the next state that is connected to by this arc. NB: this can not apply to a POP arc"

"we want the last item in the list. This is specified by the 'to' list"
Transcript show: (anArc last) last printString!
getsentence
	"comment stating purpose of message"

	| temporary variable names |
	^sentence!
Gnome
	"comment stating purpose of message"

	| temporary variable names |
	^gnome!
Goverbs
	"comment stating purpose of message"

	| temporary variable names |
	^goverbs!
Lawnform
	"comment stating purpose of message"

	| temporary variable names |
	^lawnform!
listsentence

^listsentence!
Mover
	"comment stating purpose of message"

	| temporary variable names |
	^amove!
Movers
	"comment stating purpose of message"

	| temporary variable names |
	^movers
!
Moveverbs
	"comment stating purpose of message"

	| temporary variable names |
	^moveverbs
!
Nouns
	"comment stating purpose of message"

	| temporary variable names |
	^nouns
!
Picker
	"comment stating purpose of message"

	| temporary variable names |
	^apick!
Pickverbs
	"comment stating purpose of message"

	| temporary variable names |
	^pickverbs
!
Preps
	"comment stating purpose of message"

	| temporary variable names |
	^preps
!
reform
	| t1 |
	lawnform _ Form fromDisplay: activeView insetDisplayBox.
	^ lawnform!
Rock
	"comment stating purpose of message"

	| temporary variable names |
	^rock!
scanner: aSentence
	"take the sentence and convert it to a list of strings"

 	| list index restofSentence restofList aword fred |
	list _ OrderedCollection new.

				(aSentence isEmpty) ifFalse:
	[index _ aSentence indexOf: $ .

" Have we come to the last word in the sentence? if so there will be no more blanks"
	(index = 0) ifTrue: 
	[aword _ aSentence copyWithout: $ .]
	ifFalse:
	[aword _ aSentence copyFrom: 1 to: (index - 1)].


(index = 0) ifTrue: [index _ (aSentence size) + 1. fred _ aSentence at: 1.]
ifFalse: [fred _ aSentence at:index.].
	[fred isAlphaNumeric] whileFalse:
	[ "skip over the blanks at start of string"
	index _ index + 1.
	  
	fred _ aSentence at:index.].


	restofSentence _ aSentence copyFrom: index to: (aSentence size).

	restofList _ self scanner: restofSentence.
	list add: aword; addAll: restofList.].
^list!
setlistsentence: astr
	"comment stating purpose of message"

	|  |

	listsentence _ self scanner: astr.
!
setsentence: astr
	"comment stating purpose of message"

	| temporary variable names |
	sentence_astr!
theATN
	"give the ATN"

^theATN!
Thenp
	"comment stating purpose of message"

	| temporary variable names |
	^thenp!
theParser
	"return the parser variable"

^theParser!
Toverbs
	"comment stating purpose of message"

	| temporary variable names |
	^toverbs!
Tree
	"comment stating purpose of message"

	| temporary variable names |
	^tree! !

!Garden methodsFor: 'display'!
redraw
	| t1 t2 |
	lawnform
		displayOn: Display
		at: activeView insetDisplayBox origin
		clippingBox: activeView insetDisplayBox
		rule: Form over
		mask: nil!
remodel: t1 
	"redraw the objects which should be visible"
	rock Position = t1
		ifTrue: 
			[
			(jane Purse includes: rock)
				ifFalse: 
					[
					rock dodraw]].
	gnome Position = t1
		ifTrue: [(jane Purse includes: gnome)
				ifFalse: [gnome dodraw]].
	flower Position = t1
		ifTrue: [(jane Purse includes: flower)
				ifFalse: [flower dodraw]].
	tree Position = t1 ifTrue: [tree dodraw].
pond Position = t1 ifTrue: [pond dodraw]! !

!Garden methodsFor: 'commands'!
Domove: t1 
"set Janes position to an objects position and redarw it"
	| t2 t3 t4 t5 |
t5_jane Gridpos.
	t1 = 1 ifTrue: [(jane Purse includes: gnome) ifFalse: [t5 _ gnome Gridpos]].
	t1 = 2 ifTrue: [(jane Purse includes: rock) ifFalse: [t5 _ rock Gridpos]].
	t1 = 3 ifTrue: [(jane Purse includes: flower) ifFalse: [t5 _ flower Gridpos]].
t1=4 ifTrue: [t5_tree Gridpos].
	t2 _ jane Position.
t5=jane Gridpos ifFalse: [
	jane moveto: t5 x and: t5 y.
	self remodel: t2]!
DoPickup
"pick up all objects jane is standing on"
	| count|
count_0.
	rock Position = jane Position
		ifTrue: 
			[jane erase.
count_count+1.
			jane positionat: rock Position.jane addtopurse:rock].
gnome Position = jane Position
		ifTrue: 
			[jane erase.
count_count+1.
			jane positionat: gnome Position.jane addtopurse:gnome].
flower Position = jane Position
		ifTrue: 
			[jane erase.
count_count+1.
			jane positionat: flower Position.jane addtopurse:flower].
count=0 ifTrue: [Transcript show: 'Jane is not standing on any pickable objects']!
DoPickup:what
	"pick up an object"
	what Position = jane Position
		ifTrue:
 [(jane Purse includes: what) ifFalse:
			[jane erase.
			jane positionat: what Position.
			jane addtopurse:what.]]
		ifFalse: [Transcript show: 'Jane can only pick up objects she is standing on']!
Drop: what
	"drop what"

(jane Purse includes: what) ifTrue: [jane Purse remove: what.
what positionat2: jane Position. 
what setgridpos: jane Gridpos.]
ifFalse: [Transcript show: 'Jane does not have it']!
Dropall
	
self Dropone:rock.
self Dropone: gnome.
self Dropone: flower.
!
Dropone: what
	"remove an object from jane's purse"

(jane Purse includes: what) ifTrue: [jane Purse remove: what.
what positionat2: jane Position. 
what setgridpos: jane Gridpos.]
!
East
	"set the grid position to be the x grid plus 1"

	| newgridpos newpos x oldpos|
newpos_jane Gridpos.
oldpos_jane Position.
x_newpos x.
x_ x + 1. 
(x=9)
ifTrue: [x_1].
(pond Gridpos=(x@newpos y)) ifFalse:[
jane moveto: x and: newpos y.
self remodel: oldpos.
self reform]!
Movenear: t1 
"set janes position to be near an object"
	| t2 t3 t4 t5 x y janepos|
t5_jane Gridpos.
	t1 = 1 ifTrue: [(jane Purse includes: gnome) ifFalse: [t5 _ gnome Gridpos]].
	t1 = 2 ifTrue: [(jane Purse includes: rock) ifFalse: [t5 _ rock Gridpos]].
	t1 = 3 ifTrue: [(jane Purse includes: flower) ifFalse: [t5 _ flower Gridpos]].
t1=4 ifTrue: [t5_tree Gridpos].
t1=5 ifTrue: [t5_pond Gridpos].
	t2 _ jane Position.

x_(t5 x)-1.
y_(t5 y).
x@y=jane Gridpos ifFalse: [
(pond Position = (x@y)) ifTrue: [y_ y -1].
	jane moveto: x and:  y.
	self remodel: t2]!
Moveto: t1 
	| t2 t3 t4 t5 x |
(t1=2) & (jane Purse includes: rock) ifFalse: [
	t1 = 1 ifTrue: [t5 _ gnome Gridpos].
	t1 = 2 ifTrue: [t5 _ rock Gridpos].
	t1 = 3 ifTrue: [t5 _ flower Gridpos].
t1=4 ifTrue: [t5_tree Gridpos].
	t2 _ jane Position.
x_(t5 x)-1.
	jane moveto: x and: t5 y.
	self remodel: t2]!
North
	

	| newgridpos newpos y oldpos|
newpos_jane Gridpos.
oldpos_jane Position.
y_newpos y.
y_ (y - 1). 
(y=0)
ifTrue: [y_8].
(pond Gridpos=(newpos x@y)) ifFalse:
[jane moveto: newpos x and: y.
self remodel: oldpos.
self reform]!
show
	
Transcript cr.
(jane Purse includes: rock) ifTrue: [Transcript show: #rock;cr].
(jane Purse includes: gnome) ifTrue: [Transcript show: #gnome;cr].
(jane Purse includes: flower) ifTrue: [Transcript show: #flower;cr].


!
South
	
	| newgridpos newpos y oldpos|
newpos_jane Gridpos.
oldpos_jane Position.
y_newpos y.
y_ y + 1. 
(y=9)
ifTrue: [y_1].
(pond Gridpos=(newpos x@y)) ifFalse:[
jane moveto: newpos x and: y.
self remodel: oldpos.
self reform]!
West
	
	| newgridpos newpos x oldpos|
newpos_jane Gridpos.
oldpos_jane Position.
x_newpos x.
x_ x - 1. 
(x=0)
ifTrue: [x_8].
(pond Gridpos=(x@newpos y)) ifFalse:[
jane moveto: x and: newpos y.
self remodel: oldpos.
self reform]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Garden class
	instanceVariableNames: ''!

!Garden class methodsFor: 'creation'!
create
	| t1 |
	t1 _ self new.
	^ t1! !


Garden subclass: #Entity
	instanceVariableNames: 'position shape topview gridpos '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!Entity methodsFor: 'access'!
dodraw
"redraw the entity"
	shape
		displayOn: Display
		at: position+topview insetDisplayBox origin
		clippingBox: topview insetDisplayBox
		rule: Form over
		mask: nil!
dodrawinform: aform
"redraw the entity in lawnform"
	shape
		displayOn: aform
		at: position+aform offset
		clippingBox: topview insetDisplayBox
		rule: Form over
		mask: nil!
erase
"redraw the entity in white hence erasing it"
	shape
		displayOn: Display
		at: position+ topview insetDisplayBox origin
		clippingBox: topview insetDisplayBox
		rule: Form over
		mask: Form white!
Gridpos
"return the entity's grid position"
	^ gridpos!
Position
	^ position!
positionat3: t1 and: t2 
"set the entity's real position by converting the grid position and do not redraw" 
	| t3 t4 t5 |
	t3 _ (t1 - 1) * 25 +4." + topview insetDisplayBox origin x."
	t4 _ (t2 - 1) * 25+2." + topview insetDisplayBox origin y."
	self setgridpos: t1 @ t2.
	self positionat3: t3 @ t4!
positionat: t1 and: t2 
"set the entity's real position by converting its grid position and redraw it"
	| t3 t4 t5 |
	t3 _ (t1 - 1) * 25 +4." + topview insetDisplayBox origin x."
	t4 _ (t2 - 1) * 25+2." + topview insetDisplayBox origin y."
	self setgridpos: t1 @ t2.
	self positionat: t3 @ t4!
Shape
	^ shape!
topView: t1 
	"set the entity's view"
	topview _ t1!
xsquare
	| t1 t2 |
	t1 _ position x.
	t2 _ t1 / 35.
	t2 _ t2 ceiling.
	^ t2! !

!Entity methodsFor: 'creation'!
positionat2: t1 
	"set the entity's real position and do not redraw"
	position _ t1.
	!
positionat3: t1 
	"set the entity's real position and redarw in lawnform"
	position _ t1.
self dodrawinform:topview model Lawnform
	!
positionat: t1 
"set the entity's real position and redraw"
	
	position _ t1.
	self dodraw!
setgridpos: t1 
	"set the entity's position wrt a grid"

	gridpos _ t1!
setshape: t1 
	| t2 |
	shape _ t1! !


MouseMenuController subclass: #Gardenmenu
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!Gardenmenu methodsFor: 'menu messages'!
ATNTalk
	| request token atext atn theparser newsentence |
	request _ FillInTheBlank
		request: 'What do you want?' 
		displayAt: Sensor waitButton 
		centered: true
		action: [:request | 
		
request isEmpty ifFalse:
	[model setlistsentence:request.
	atn _ model theATN.
	theparser _ model theParser.
	newsentence _ model listsentence.
	theparser Parse: atn sentence: newsentence.
	"token_model Aparser NLParse: request.
(model Moveverbs includes: token asSymbol) ifTrue: [model Mover delegate: model getsentence]
ifFalse: [(model Pickverbs includes: token asSymbol) ifTrue: [model Picker delegate: model getsentence]].model reform"]]
initialAnswer: ''!
direct

|amenu answer|
amenu_PopUpMenu labels: 'North
South
East
West'.
answer_amenu startUp.
(answer=1) ifTrue: [model North].
(answer=2) ifTrue: [model South].
(answer=3) ifTrue: [model East].
(answer=4) ifTrue: [model West].
model reform!
DoPickup
	"comment stating purpose of message"

	| temporary variable names |
	model DoPickup.
model reform!
Drop
	"comment stating purpose of message"

	| temporary variable names |
	model Drop: 1!
Dropall
	"comment stating purpose of message"

	| temporary variable names |
	model Dropall!
dropit

|amenu answer|
amenu_PopUpMenu labels: 'Drop Rock
Drop Gnome
Drop Flower'.
answer_amenu startUp.
(answer=1) ifTrue: [model Drop:model Rock].
(answer=2) ifTrue: [model Drop:model Gnome].
(answer=3) ifTrue: [model Drop:model Flower]!
Move
	| t1 t2 t3 |
	model Domove.
	model reform!
movenearto

|amenu answer|
amenu_PopUpMenu labels: 'Move near the Gnome
Move near the Rock
Move near the Flower
Move near the Tree
Move near the pond'.
answer_amenu startUp.
model Movenear:answer.
model reform!
moveto

|amenu answer|
amenu_PopUpMenu labels: 'Move to the Gnome
Move to the Rock
Move to the Flower
Move to the Tree'.
answer_amenu startUp.
model Domove:answer.
model reform!
pickup

|amenu answer|
amenu_PopUpMenu labels: 'Pickup Rock
Pickup Gnome
Pickup Flower'.
answer_amenu startUp.
(answer=1) ifTrue: [model DoPickup:model Rock].
(answer=2) ifTrue: [model DoPickup:model Gnome].
(answer=3) ifTrue: [model DoPickup:model Flower]!
Show
	
	model show!
Talk
	| request token atext |
	request _ FillInTheBlank
		request: 'What do you want?' 
		displayAt: Sensor waitButton 
		centered: true
		action: [:request | 
		
request isEmpty ifFalse:
	[model setsentence:request.
	token_model Aparser NLParse: request.
(model Moveverbs includes: token asSymbol) ifTrue: [model Mover delegate: model getsentence]
ifFalse: [(model Pickverbs includes: token asSymbol) ifTrue: [model Picker delegate: model getsentence]].model reform]]
initialAnswer: ''! !

!Gardenmenu methodsFor: 'initialisation'!
initialize
"set up the yellow button menu"
	| amenu menumessages |
	super initialize.
	amenu _ PopUpMenu labels: 'Move...
Move To...
Move near...
ATN Talk
Talk
Show Purse
Pick Up...
Pick it up
Drop...
Drop All' lines: #( 3 6 8 10).
	menumessages _ #(direct moveto movenearto ATNTalk Talk Show pickup DoPickup dropit Dropall).
	self yellowButtonMenu: amenu yellowButtonMessages: menumessages! !


View subclass: #Gardenview
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!Gardenview methodsFor: 'display'!
displayView
	
	model redraw!
update: t1 
	
	self display! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Gardenview class
	instanceVariableNames: ''!

!Gardenview class methodsFor: 'creation'!
open
	| t1 t2 t3 t4 |
	t2 _ self new.
	t3 _ Garden create.
	t3 adddetails2.
	t2 controller: Gardenmenu new; model: t3; borderWidth: 2; insideColor: Form white.
	t1 _ StandardSystemView new.
	t1 label: 'GardenWorld'; minimumSize: 200 @ 200; maximumSize: 200 @ 200; addSubView: t2.
	t3 activeView: t2.
t3 adddetails3.
	t1 controller open! !


Entity subclass: #Inanimates
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!Inanimates methodsFor: 'creation'!
new
	| t1 |
	t1 _ self new.
	^ t1! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Inanimates class
	instanceVariableNames: ''!

!Inanimates class methodsFor: 'creation'!
new
	| t1 |
	t1 _ super new.
	^ t1! !


Object subclass: #NLParser
	instanceVariableNames: 'result amodel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!NLParser methodsFor: 'Action Functions'!
ActionType: anAction
	"return the what type of action is being specified"

^anAction first!
GetActionList: anArc
	"get the list of actions specified in the arc to set the registers"

(((anArc last) size) <= 1) ifTrue: [^ OrderedCollection new.]
ifFalse: [ ^ (anArc last) copyFrom: 1 to: (((anArc last) size) - 1)]!
Setr: aRegister form: aForm
	"Sets the given register to contain aForm as its contents "

	| setlist |
	setlist _ OrderedCollection new.
	setlist add: #setr; add: aRegister; add: aForm.
^setlist!
UpdateRegisters: actionList registerbank: aRegisterBank value: aword| index action regind |
.
	"update the contents of the registers in the register bank as specified in the actionList."

(actionList isEmpty) ifFalse:
[
  index _ 1.
  [index <= (actionList size)] whileTrue:
  [
	"for each of the actions in the action list, 	perform them on the registers"

	action _ (actionList at: index) at: 2.
	(action  = #action) ifTrue:[regind _ 1].
	(action  = #object) ifTrue:[regind _ 2].
	(action  = #where) ifTrue:[regind _ 3].

	aRegisterBank at: regind put: aword.
     index _ index + 1.
  ].
  ^aRegisterBank.
]! !

!NLParser methodsFor: 'State Functions'!
CurrentArc: anArcList
	"get the first arc from the list of arcs."

^anArcList first!
FindState: anATN label: aStateLabel 
	"given the ATN, find the requested state. Assumes that there is such a 
	state in the ATN, given by said label"
	"(anATN isEmpty) ifTrue: [^false]."

	| tail index |

	index _ 1.
	[index <= (anATN size)] whileTrue:
		[ (aStateLabel = (self GetStateLabel: (anATN at: index)) ) 
			ifTrue: [^anATN at: index].
		  index _ index + 1. 
		].
	
"!!!!!! if you get here then its an error!!!!!! "!
GetArcs: aState
	"get the list of arcs that emanate from this state"

	^ aState last!
GetStateLabel: aState
	"get the label of this state"

	^ aState first!
InitialState: anATN
	"get the first state of the ATN"

^anATN first! !

!NLParser methodsFor: 'Parse Pair Functions'!
GetRegisterBank: aParsePair
	"strip off the register bank from the parse pair"

	^aParsePair last!
GetSentence: aParsePair
	"strip off the sentence from the parse pair"

	^aParsePair first!
MakeParsePair: aSentence registerBank: aRegisterBank
	"makes the pair of <unparsed sentence>, <registerbank>.
	Both of these will be in the form of lists"

| pair |
pair _ OrderedCollection new.
pair add: aSentence; add: aRegisterBank.
^pair!
SetRegister: aRegisterBank register: aRegister value: aValue
	"if the register does not exist in the register bank then add it with these values. if it exists then the register to contain this new value"

| regpair newRegisterBank index |
regpair _ OrderedCollection new.
regpair add: aRegister; add: aValue.
newRegisterBank _ OrderedCollection new.
newRegisterBank _ aRegisterBank.
index _ 1.
[index <= (newRegisterBank size)] whileTrue:
["find the register in the register bank."
(aRegister = ((newRegisterBank at: index) first) ) ifTrue:[ 
	"ok, change the value for this register"
	newRegisterBank at: ((newRegisterBank at: index) last) put: aValue.
	^aRegister.].
index _ index+1.
].

newRegisterBank add: regpair.
^newRegisterBank! !

!NLParser methodsFor: 'Auxiliary Parser'!
Parse: anATN sentence: aSentenceList
	"take the sentence with the ATN as a guide and parse it
	For the purposes of this parser the register bank isan array composed of three cells for each of the registers:
Cell 1: The Action register
Cell 2: The Object register
Cell 3: The Where register
From the results of these registers we may determine the necessary messages to send to the model. Note how we do not need to worry about the contents of the Action register as we have confined ourselves to consider the case of moving Jane about the garden"

| return aregisterbank |
aregisterbank _ Array new:3.
return _ self ParseAux: anATN state: (self InitialState: anATN) registerbank: aregisterbank sentence: aSentenceList.
( return = nil) ifFalse: 
[
	((return at: 2) = nil) ifFalse: [
	((return at: 2)=#gnome) ifTrue: [amodel Domove: 1].
	((return at: 2)=#rock) ifTrue: [amodel Domove: 2].
	((return at: 2)=#flower) ifTrue: [amodel Domove: 3].
	((return at: 2)=#tree) ifTrue: [amodel Domove: 4]
	].
	((return at: 3) = nil) ifFalse: [
	((return at: 3)=#north) ifTrue: [amodel North].
	((return at: 3)=#up) ifTrue: [amodel North].
	((return at: 3)=#south) ifTrue: [amodel South].
	((return at: 3)=#down) ifTrue: [amodel South].
	((return at: 3)=#east) ifTrue: [amodel East].
	((return at: 3)=#right) ifTrue: [amodel East].
	((return at: 3)=#west) ifTrue: [amodel West].
	((return at: 3)=#left) ifTrue: [amodel West].
	].
]


!
ParseAux: anATN state: aState registerbank: aRegisterBank sentence: restOfSentence
	"recursively parse the sentence, trying each arc emanating from the state"

"first get the arcs that emanate from the state"
| arcs arc word nextState return acat newSentence index actionlist newRegisterBank |

arcs _ self GetArcs: aState.
index _ 1.
newRegisterBank _ aRegisterBank.
(restOfSentence isEmpty) ifFalse: [word _ restOfSentence first].
[index <= (arcs size) ] whileTrue:
[
	arc _ arcs at: index.
	newSentence _ restOfSentence copyFrom: 2 to: (restOfSentence size).

"assume the test will always be true so can just parse the rest of the string"

	(arc first = #cat) ifTrue: 
	[ "great, check that the current word is in the category"
		nextState _ (self GetNextState: arc). 
		acat _ self GetCategory: arc.
    		(acat includes: word) ifTrue:
		["ok so far, parse to the next state"
			actionlist _ self GetActionList: arc.
			newRegisterBank _ self UpdateRegisters: (self 										GetActionList: arc) 
								registerbank: aRegisterBank 
								value: word.
			return _ (self ParseAux: anATN 
								state: (self FindState: anATN 
											label: nextState)
								registerbank: aRegisterBank
								sentence: newSentence).

		].
	].

	(arc first = #pop) ifTrue:
	[ return _ newRegisterBank.
		^return].

	index _ index+ 1.
].

^return.
! !

!NLParser methodsFor: 'Arc Functions'!
GetCategory: anArc
	"assumes that the caller is a category arc"

	^anArc at:2!
GetNextState: anArc
	"find the next state as given by the arc. Assumes that arc is not a POP (as there is no next state in this case). Also assumes that the last thing specified in the arc is a 'to' list"


^(((anArc last) last) last)! !

!NLParser methodsFor: 'initialise'!
aninit:model
	"comment stating purpose of message"

	| temporary variable names |
	amodel_model! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

NLParser class
	instanceVariableNames: ''!

!NLParser class methodsFor: 'creation'!
create
	"invoke a new parser"

^self new!
create: model
	"invoke a new parser"

| me |
me_self new.
me aninit: model.
^me! !


ATN variableSubclass: #NPATN
	instanceVariableNames: 'amodel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!NPATN methodsFor: 'accessing'!
at: index
	"comment stating purpose of message"

	| temporary variable names |
	^statelist at: index!
cdr
	"return the tail of the list. As with the cdr of lisp there must be at least  a pair of values."

	| tail |
	tail _ alist copyFrom: 2 to: (alist size).
	^tail!
first
	"comment stating purpose of message"

	| temporary variable names |

	^statelist first!
last
	"comment stating purpose of message"

	| temporary variable names |
	^statelist last!
size
	"comment stating purpose of message"

	| temporary variable names |
	^statelist size! !

!NPATN methodsFor: 'initialisation'!
init: anmodel
	"hard-wire the ATN for the noun phrase (NP)"


	| aword actionList arcList g1 g2 g3 saveLast n2 g4 |
	amodel _ anmodel.
statelist_OrderedCollection new.
aword _ Words new.
"--- add the structure of node g1 ---"
	actionList _ OrderedCollection new.
	actionList add: (aword Setr: #action form: #**).
	actionList add: (aword To: #g2).
	arcList _ OrderedCollection new.
	arcList add: (aword cat: anmodel Goverbs test: #t actionlist: actionList).

	g1_aword State: #g1 arclist: arcList.
	statelist add: g1.

"--- add the structure of node g2 ---"
	actionList _ OrderedCollection new.
	actionList add: (aword To: #g3). 
	arcList _ OrderedCollection new.
	arcList add: (aword cat: anmodel Toverbs test: #t actionlist: actionList).

	actionList _ OrderedCollection new.
	actionList add: (aword Setr: #where form: #**).
	actionList add: (aword To: #g4).
	arcList add: (aword cat: anmodel Adverbs test: #t actionlist: actionList).

	g2 _ aword State: #g2 arclist: arcList.
	statelist add: g2.

"--- add the structure of node g3 ---"
	actionList _ OrderedCollection new.
	actionList add: (aword To: #n2).
	arcList _ OrderedCollection new.
	arcList add: (aword cat: anmodel Articles test: #t actionlist: actionList).

	g3_aword State: #g3 arclist: arcList.
	statelist add: g3.

"--- add the structure of node n2 ---"
	actionList _ OrderedCollection new.
	actionList add: (aword Setr: #object form: saveLast).
	actionList add: (aword To: #g4).
	arcList _ OrderedCollection new.
	arcList add: (aword cat: (anmodel Nouns) test: #t actionlist: actionList).

	n2_aword State: #n2 arclist: arcList.
	statelist add: n2.

"--- add the structure of node g4 ---"
	actionList _ OrderedCollection new.
	actionList add: (aword Setr: #where form: #**).
	actionList add: (aword To: #g3).
	arcList _ OrderedCollection new.
	arcList add: (aword cat: (anmodel Preps) test: #t actionlist: actionList).

	arcList add: (aword pop: #** and: #t).

	g4 _ aword State: #g4 arclist: arcList.
	statelist add: g4.


^statelist.
! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

NPATN class
	instanceVariableNames: ''!

!NPATN class methodsFor: 'creation'!
create: anmodel
	"comment stating purpose of message"

	| state1 state2 state3 anarclist dest arccatt1 aword t1 arccat |
	t1_self new.
	t1 init: anmodel.


^t1! !


Entity subclass: #Person
	instanceVariableNames: 'purse '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!Person methodsFor: 'initialise'!
doinit
	
	purse_Bag new!
init
	"comment stating purpose of message"

	| temporary variable names |
	purse_Bag new! !

!Person methodsFor: 'access'!
Purse
	
	^purse! !

!Person methodsFor: 'commands'!
addtopurse: item
	
	purse add: item!
moveto: t1 and: t2 
	"set the position and the grid position"
	self erase.
	self positionat: t1 and: t2! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Person class
	instanceVariableNames: ''!

!Person class methodsFor: 'creation'!
create
	| t1 |
	t1 _ self new.
t1 doinit.
	^ t1! !


Form subclass: #Shapes
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!Shapes methodsFor: 'no messages'! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Shapes class
	instanceVariableNames: ''!

!Shapes class methodsFor: 'initialise'!
aflowerform
	| t1 |
	t1 _ Form
				extent: 16 @ 20
				fromArray: #(0 128 448 320 544 1584 6476 12294 6476 1584 544 544 320 448 2184 5268 4772 4548 4088 128 )
				offset: 0 @ 0.
	^ t1!
agnomeform
	| t1 |
	t1 _ Form
				extent: 16 @ 20
				fromArray: #(0 0 480 784 1128 2264 2112 8160 2114 1156 776 1168 2296 2312 2296 1216 4064 8176 12312 8176 )
				offset: 0 @ 0.
	^ t1!
ajohn
	| t1 |
	t1 _ Cursor
				extent: 16 @ 16
				fromArray: #(65535 65535 49155 49155 49155 49155 49155 49155 49155 65535 65535 0 0 0 0 0 )
				offset: 0 @ 0.
	^ t1!
apersonform
	| t1 |
	t1 _ Form
				extent: 16 @ 20
				fromArray: # (2064 1056 960 576 1056 1632 1056 576 384 384 3024 5160 9252 9252 1056 576 1440 2064 2064 2064 )
				offset: 0 @ 0.
	^ t1!
apersonform1
	| t1 |
	t1 _ Form
				extent: 16 @ 20
				fromArray: #(0 960 2016 3120 6168 3120 1632 960 384 8184 8184 384 384 960 1632 3120 6168 12300 24582 0 )
				offset: 0 @ 0.
	^ t1!
apondform
	| t1 |
	t1 _ Form
				extent: 16 @ 20
				fromArray: # (0 0 0 0 3096 4644 25026 0 3096 4644 25026 0 3096 4644 25026 0 0 0 0 0 )
				offset: 0 @ 0.
	^ t1!
arockform
	| t1 |
	t1 _ Form
				extent: 16 @ 20
				fromArray: #(0 0 0 0 480 1976 3204 7812 6148 12316 30914 16482 16658 16658 16514 16578 24642 8188 0 0 )
				offset: 0 @ 0.
	^ t1!
asquareform
	| t1 |
	t1 _ Form
				extent: 16 @ 16
				fromArray: #(65535 65535 49155 49155 49155 49155 49155 49155 49155 65535 65535 0 0 0 0 0 )
				offset: 0 @ 0.
	^ t1!
atreeform
	| t1 |
	t1 _ Form
				extent: 16 @ 20
				fromArray: # (0 0 992 544 1584 2056 2056 4100 4100 4228 4228 7516 1488 992 448 448 448 992 2032 4088 )
				offset: 0 @ 0.
	^ t1! !


Object subclass: #Verbs
	instanceVariableNames: 'amodel things directions ajoin '
	classVariableNames: 'ClassVarName1 ClassVarName2 '
	poolDictionaries: ''
	category: 'NL-World'!

!Verbs methodsFor: 'initialise'!
init: model
	"set up collections"
	amodel_model.
things_OrderedCollection new.
things add: #gnome; add: #rock; add: #flower; add: #tree; add: #pond.
directions_ OrderedCollection new.
directions add: #east; add: #west; add: #north; add: #south; add: #dummy; add: #left; add: #right; add: #up; add: #down! !


Verbs subclass: #JoinVerb
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!JoinVerb methodsFor: 'joinstuff'!
join: rest
	"connect up a move and a pick"

	| token |
	token_amodel Aparser NLParse: rest.
(amodel Moveverbs includes: token asSymbol) ifTrue: [amodel Mover delegate: amodel getsentence]
ifFalse: [(amodel Pickverbs includes: token asSymbol) ifTrue: [amodel Picker delegate: amodel getsentence]].amodel reform! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

JoinVerb class
	instanceVariableNames: ''!

!JoinVerb class methodsFor: 'creation'!
create: model
	"comment stating purpose of message"

	| me |
	me_self new.
me init: model.
^me! !


Verbs subclass: #MoveVerb
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!MoveVerb methodsFor: 'adjectives'!
aprep: whichone
	"to/near"

	
	(whichone asSymbol = #to) ifTrue: [self to: amodel getsentence] ifFalse: [self near: amodel getsentence]!
delegate: rest
	"partition the move"

	| next index token|
token_(rest asLowercase) asSymbol.
	(directions includes: token) ifTrue: [index_(directions indexOf: token).
(index rem: 5) = 1 ifTrue: [amodel East].
(index rem: 5) = 2 ifTrue: [amodel West].
(index rem: 5) = 3 ifTrue: [amodel North].
(index rem: 5) = 4 ifTrue: [amodel South]]
ifFalse: [next_(amodel Aparser NLParse: rest) asSymbol.
		(amodel Preps includes: next) ifTrue: [self aprep: next]].
next_(amodel Aparser NLParse: amodel getsentence) asSymbol.
(next =#and) ifTrue: [amodel Anand join: amodel getsentence].

!
near: rest
	
	| next index |
	next_amodel Aparser NLParse: rest.
(amodel Articles includes: next) ifTrue: [next_amodel Aparser NLParse: amodel getsentence].
(things includes: next) ifTrue: [amodel Movenear: (things indexOf: (next))].

!
to: rest
	
	| next index |
	next_amodel Aparser NLParse: rest.
(amodel Articles includes: next) ifTrue: [next_amodel Aparser NLParse: amodel getsentence].
(things includes: next) ifTrue: [amodel Domove: (things indexOf: (next asSymbol))].

	(directions includes: (next)) ifTrue: [index_(directions indexOf: next).
(index rem: 5) = 1 ifTrue: [amodel East].
(index rem: 5) = 2 ifTrue: [amodel West].
(index = 3) ifTrue: [amodel North].
(index = 4) ifTrue: [amodel South]]! !

!MoveVerb methodsFor: 'initialise'!
init: model
	"comment stating purpose of message"

	| temporary variable names |
	amodel_model.
things_OrderedCollection new.
things add: #gnome; add: #rock; add: #flower; add: #tree.
directions_ OrderedCollection new.
directions add: #east; add: #west; add: #north; add: #south; add: #dummy; add: #left; add: #right; add: #up; add: #down! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

MoveVerb class
	instanceVariableNames: ''!

!MoveVerb class methodsFor: 'creation'!
create: model
	"comment stating purpose of message"

	| me |
	me_self new.
me init: model.
^me! !


Verbs subclass: #PickVerb
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!PickVerb methodsFor: 'adjectives'!
anadverb:rest
	"pick up ..."

	| next index |
		next_amodel Aparser NLParse: rest.
(amodel Articles includes: next) ifTrue: [next_amodel Aparser NLParse: amodel getsentence].
(things includes: next) ifTrue: [index_(things indexOf: (next asSymbol)).
(index=1) ifTrue: [amodel DoPickup: amodel Gnome].
(index=2) ifTrue: [amodel DoPickup: amodel Rock].
(index=3) ifTrue: [amodel DoPickup: amodel Flower]]
ifFalse: [Transcript show: 'What do you want to pick up'].
!
anobject:rest
	"pick ... up"

	| next index nextnext |
		next_amodel Aparser NLParse: rest.
(amodel Articles includes: next) ifTrue: [next_amodel Aparser NLParse: amodel getsentence].
nextnext_(amodel Aparser NLParse: amodel getsentence).
(nextnext=#up) ifTrue:[
(things includes: next) ifTrue: [index_(things indexOf: (next asSymbol)).
(index=1) ifTrue: [amodel DoPickup: amodel Gnome].
(index=2) ifTrue: [amodel DoPickup: amodel Rock].
(index=3) ifTrue: [amodel DoPickup: amodel Flower]
ifFalse: [Transcript show: 'pick what?']]
ifFalse: [Transcript show: 'What do you want me to do with it?']]!
delegate: rest 
	"pick what?"

	| next index token |
	token _ (amodel Aparser NLParse: rest) asSymbol.
	(amodel Adverbs includes: token)
		ifTrue: [self anadverb: amodel getsentence].
	token = #it
		ifTrue: 
			[token _ (amodel Aparser NLParse: amodel getsentence) asSymbol.
			token = #up
				ifTrue: [amodel DoPickup]
				ifFalse: [Transcript show: 'pick what?']]
		ifFalse: [(amodel Articles includes: token)
				ifTrue: [self anobject: amodel getsentence]].
	token _ (amodel Aparser NLParse: amodel getsentence) asSymbol.
	token = #and ifTrue: [amodel Anand join: amodel getsentence]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

PickVerb class
	instanceVariableNames: ''!

!PickVerb class methodsFor: 'creation'!
create: model
	"comment stating purpose of message"

	| me |
	me_self new.
me init: model.
^me! !


Object subclass: #Words
	instanceVariableNames: 'themodel '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'NL-World'!

!Words methodsFor: 'semantic stuff'!
NLParse: astr 
"A scanner to break up the input into"

	| token rest  a b |
token_'QAZ'.
astr isEmpty ifFalse: [
	token _ astr copyUpTo: $ .
rest_''.

	"t3 _ astr copyReplaceTokens: token with: ''."
a_astr indexOf: $ .
a=0 ifFalse: [
(astr isEmpty) ifFalse: [b_astr size.
rest_astr copyFrom: a to: b]].
	rest isEmpty ifFalse: [rest _ rest copyFrom: 2 to: rest size].
	themodel setsentence: rest.
token_token asLowercase].
	^token! !

!Words methodsFor: 'initialise'!
init: model
	"comment stating purpose of message"

	| temporary variable names |
	themodel_model!
new
	| t1 t2 t3 t4 |
	t4 _ self new! !

!Words methodsFor: 'primitives'!
cat: category test: test actionlist: actionlist
	"category is a list."

	| list |
	list_OrderedCollection new.
list add: #cat; add: category; add: test; add: actionlist.
^list!
pop: aform and: atest
	"comment stating purpose of message"

	| list |
	list_OrderedCollection new.
list add: #pop.
list add: aform.
list add: atest.
^list.
!
push: anatn test: test actions: actionlist
	"constructs the list that contains
the atn, the test and the actionlist as items.
Included in the actionlist is the final 'to' action"

	| list1 |
	list1_OrderedCollection new.
list1 add: #push; add: anatn; add: actionlist.
^list1.
!
Setr: register form: aform
	"constructs a register list"

	| list |
	list_OrderedCollection new.
list add: #setr; add: register; add: aform.
^list!
State: label  arclist: arclist
	"makes a list of the state (designated by its label) and all arcs that leave it"

	| list |
	list_OrderedCollection new.
list add: label; add: arclist.
^list!
To: label 
	"makes a list of a new label prepended by the word 'to' "

	| list |
	list_OrderedCollection new.
list add: #To; add: label.
^list! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Words class
	instanceVariableNames: ''!

!Words class methodsFor: 'creation'!
create: model

	| t1 t2 t3 t4 |
	t4 _ self new.
t4 init: model.
^t4! !
