; test of X + O game

! (SetUpX+O)
  
! (define *xm (FirstAction (GetMachineActions X+OGameProblem)))

= (*xm '(e e e   e e e   e e e))
  (x e e   e e e   e e e)

! (define *om (FirstAction (GetOpponentActions X+OGameProblem)))

= (*om '(e e e   e e e   e e e))
  (o e e   e e e   e e e)

! (define *e (GetEvalFN X+OGameProblem))

= (*e '(x o o e e e x e e) #f)
  55

= (*e '(o x o x e e e e e) #f)
  -10

! (define *g1 (MakeStateGenerator '(e e e e e e e e e)
                                  X+OGameProblem
                                  #t))
! (define *g2 (MakeStateGenerator '(e e e e e e e e e)
                                  X+OGameProblem
                                  #t))

= (*g1)
  (x e e  e e e  e e e)

= (*g1)
  (e x e  e e e  e e e)

= (*g2)
  (x e e  e e e  e e e)

= (*g1)
  (e e x  e e e  e e e)

; minimax
= (FindBestMachineMove '(e e e  e e e  e e e)
                       X+OGameProblem
                       #f
                       1)
  (5 (e e e  e e e  e e x)
     (e e e  e e e  x e e)
     (e e e  e x e  e e e)
     (e e x  e e e  e e e)
     (x e e  e e e  e e e))
= (GetCount X+OGameProblem)
  9

; alpha-beta
= (FindBestMachineMove '(e e e  e e e  e e e)
                       X+OGameProblem
                       #t
                       1)
  (5 (e e e  e e e  e e x)
     (e e e  e e e  x e e)
     (e e e  e x e  e e e)
     (e e x  e e e  e e e)
     (x e e  e e e  e e e))
= (GetCount X+OGameProblem)
  9

= (FindBestMachineMove '(x o e  x e e  o e e)
                       X+OGameProblem
                       #t
                       1)
  (105 (x o e  x x e  o e e) )
= (GetCount X+OGameProblem)
  5

; minimax
= (FindBestMachineMove '(e e e  e e e  e e e)
                       X+OGameProblem
                       #f
                       3)
  (55 (e e e  e e e  e e x)
      (e e e  e e e  x e e)
      (e e e  e x e  e e e)
      (e e x  e e e  e e e)
      (x e e  e e e  e e e))
= (GetCount X+OGameProblem)
  585

; alpha-beta
= (FindBestMachineMove '(e e e  e e e  e e e)
                       X+OGameProblem
                       #t
                       3)
  (55 (e e e  e e e  e e x)
      (e e e  e e e  x e e)
      (e e e  e x e  e e e)
      (e e x  e e e  e e e)
      (x e e  e e e  e e e))
= (GetCount X+OGameProblem)
  206

; minimax
= (FindBestMachineMove '(x o e  x e e  o e e)
                       X+OGameProblem
                       #f
                       3)
  (INFINITY (x o e  x x e  o e e) )
= (GetCount X+OGameProblem)
  85

; alpha-bata
= (FindBestMachineMove '(x o e  x e e  o e e)
                       X+OGameProblem
                       #t
                       3)
  (INFINITY (x o e  x x e  o e e) )
= (GetCount X+OGameProblem)
  54

; minimax
= (FindBestMachineMove '(x o e  e x e  e e o)
                       X+OGameProblem
                       #f
                       3)
  (INFINITY (x o e  e x e  x e o)
             (x o e  x x e  e e o) )
= (GetCount X+OGameProblem)
  85
  
; alpha-beta
= (FindBestMachineMove '(x o e  e x e  e e o)
                       X+OGameProblem
                       #t
                       3)
  (INFINITY (x o e  e x e  x e o)
             (x o e  x x e  e e o) )
= (GetCount X+OGameProblem)
  60
  
; alpha-beta
= (FindBestMachineMove '(x o e  e e e  e e e)
                       X+OGameProblem
                       #t
                       5)
  (INFINITY (x o e  e e e  x e e)
             (x o e  e x e  e e e)
             (x o e  x e e  e e e) )
= (GetCount X+OGameProblem)
  1073
