; Animal Kingdom Example
; ====== ======= =======

; This is similar to the Bestiary example 3.5.3 except it add a
; primitive explanation feature - when asked why something is
; the case it replies that it either knew it originally or was
; told it by the user. The form of the patterns and the original
; facts are different from the Bestiary example.
;
; This example illustrates the use of the Associative Network
; toolbox to answer questions about animals. Simple statements and
; questions about animals are recognized using the pattern matching
; toolbox and a associative network maintained and queried.
; The form that statements about animals can take are:
;     (an invertebrate is an aninmal)
;     (an animal is an organism)
; The questions that can be answered are of the form:
;     (what is an animal)
;     (is an invertebrate an animal)
;     (why is an invertebrate an animal)

; A few initially known facts about organisms

(define AnimalKingdom
  (MakeAN
   (CONCEPT 'organism     '(is fact))
   (CONCEPT 'plant        (AKO 'organism) '(is fact))
   (CONCEPT 'animal       (AKO 'organism) '(is fact))
   (CONCEPT 'invertebrate (AKO 'animal)   '(is fact))))

; facts in the knowledge base are lists of the form
;       (pattern-to-match procedure-to-invoke)

(define MakeFact
  (lambda (aPattern aProcedure) (list aPattern aProcedure)))

(define GetPattern car)
(define GetProc    cadr)

(define xarticle?
  (lambda (anAL)
    ; is xArticle bound to a or an?
    (let ((aWord (GetAssociationValue 'xArticle anAL)))
      (or (eq? aWord 'a) (eq? aWord 'an)))))

(define yarticle?
  (lambda (anAL)
    ; is yArticle bound to a or an?
    (let ((aWord (GetAssociationValue 'yArticle anAL)))
      (or (eq? aWord 'a) (eq? aWord 'an)))))

(define ValidSentences
  (MakeKB
   (MakeFact (PATTERN (? 'xArticle xarticle?)
                      (? 'x)
                      'is
                      (? 'yArticle yarticle?)
                      (? 'y))
             (lambda (anAL)
               (let ((subclass (GetAssociationValue 'x anAL))
                     (supclass (GetAssociationValue 'y anAL)))
                 (set! AnimalKingdom
                       (AddConcept AnimalKingdom
                                   (CONCEPT subclass
					    (AKO supclass)
					    '(is told)))))))
   (MakeFact (PATTERN 'what
		      'is
		      (? 'xArticle xarticle?)
		      (? 'x))
             (lambda (anAL)
               (let ((superClass
                      (GetAKOLinks AnimalKingdom
                                   (GetAssociationValue 'x anAL))))
                 (if superClass
                     (begin
		       (display (GetAssociationValue 'xArticle anAL))
		       (display " ")
		       (display (GetAssociationValue 'x anAL))
		       (display " is a subclass of ")
		       (display (car superClass)))
                     (display "I don't know - you tell me"))
                 (newline))))
   (MakeFact (PATTERN 'is
                      (? 'xArticle xarticle?)
                      (? 'x)
                      (? 'yArticle yarticle?)
                      (? 'y))
             (lambda (anAL)
               (let ((subclass (GetAssociationValue 'x anAL))
                     (supclass (GetAssociationValue 'y anAL)))
                 (if (member supclass
                             (GetAKOChain AnimalKingdom subclass))
                     (display "Yes it is")
                     (display "No it is not")))))
   (MakeFact (PATTERN 'why
                      'is
                      (? 'xArticle xarticle?)
                      (? 'x)
                      (? 'yArticle yarticle?)
                      (? 'y))
             (lambda (anAL)
               (let* ((subclass (GetAssociationValue 'x anAL))
                      (isSlots (GetLinkSymbolSlots AnimalKingdom
                                                   subclass
                                                   'is))
                      (supclass (GetAssociationValue 'y anAL))
                      (links (GetAKOLinks AnimalKingdom subclass))
                      (chain (GetAKOChain AnimalKingdom subclass)))
                 (cond ((eq? supclass subclass)
                        (display "Because they are identical"))
                       ((member supclass links)
                        (cond ((eq? 'fact (cadar isslots))
                               (DisplayList "Because I new it initially"))
                              ((eq? 'told (cadar isslots))
                               (display "Because you said so"))
                              (else (Fatal-Error "Bad is slots"))))
                       ((member supclass chain)
                        (display "Because ")
                        (display (GetAssociationValue 'xArticle anAL))
                        (display " ")
                        (display subclass)
                        (display " is a ")
                        (display (car links)))
                       (else
                        (display "Sorry - I didn't know it was")))
                 (newline))))))

; get sentences in a loop

(define AskAboutAnimals
  (lambda ()
    (DisplayLine "Please supply your input as a list"
                 "and use (bye) to terminate conversation")
    (display " >> ")
    (do ((sentence (read))
         (aRL #f))
        ((equal? sentence '(bye)) #f)
        (newline)
        (set! aRL (RetrieveAllByString ValidSentences
                                       sentence
                                       GetPattern))
        (if (null? aRL)
            (begin (display "Sentence not understood") (newline))
            (let ((fact (GetFact  (CurrentRetrievedElement aRL)))
                  (anAL (GetAList (CurrentRetrievedElement aRL))))
              ((GetProc fact) anAL)))
        (newline)
        (display " >> ")
        (set! sentence (read)))))

(DisplayLine "Type (AskAboutAnimals) to converse about animals")
