; ========== some simple Data Collection Devices ==========
(defFlavour DataCollector (ako Vanilla) (ivars name obs) testivars getivars setivars)

; ----- a Counter -----
(defFlavour Count (ako DataCollector) 
  (ivars counter) setivars getivars testivars)

(defMethod (update! Count) (aValue) 
  (if (self 'counter?)
      (set! counter (+ counter aValue))             
      (set! counter aValue))
  (if (self 'obs?)
      (self 'obs! (+ (self 'obs) 1))
      (self 'obs! 1)))

(defMethod (reset!  Count) () (self 'obs! 0) (set! counter 0))

(defMethod (show Count) ()
  (if (self 'obs?)
      (begin (displayLine "--- counter:" (self 'name)) 
             (displayLine (self 'obs) "observations were made.")
             (displayLine "    The value of this count is:" counter))
      (displayLine "*** this counter has not been updated !")))

; ----- a Tally -----
(defFlavour Tally (ako DataCollector) 
  (ivars sum min max) 
   setivars getivars testivars) 

(defMethod (update! Tally) (aValue)
  (if (self 'obs?)
      (self 'obs! (+ 1 (self 'obs)))
      (self 'obs! 1))
  (if (self 'sum?)
      (set! sum  (+ aValue sum))
      (set! sum aValue))
  (if (or (not (self 'min?)) 
          (<? aValue min)) (set! min aValue))
  (if (or (not (self 'max?)) 
          (>? aValue max)) (set! max aValue)))
      
(defMethod (reset! tally) () 
  (self 'obs! 0) (set! sum 0) (set! min 0) (set! max 0))

(defMethod (show    Tally) ()
  (if (self 'obs?)
      (begin (displayLine "--- tally:" (self 'name)) 
             (displayLine (self 'obs) "observations were made.") 
             (displayLine "    Mean: " 
                          (if (not (zero? (self 'obs)))
                              (/ sum (self 'obs))
                              "0"))
             (displayLine "    Min : " min) 
             (displayLine "    Max : " max))))

; ----- an Accumulate -----

(defFlavour Accumulate (ako Vanilla) 
  (ivars lastChange lastValue obs integral min max) 
   setivars getivars testivars)

(defMethod (update! Accumulate) (aTime aValue)
  (define lastValuesDuration 0)
  (if (not (self 'lastValue?))
      (set! lastValue 0))
  (if (not (self 'lastChange?))
      (set! lastChange 0))
  (set! lastValuesDuration (- aTime lastChange))
  (if (self 'obs?)
      (set! obs (+ 1 obs))
      (set! obs 1))
  (if (self 'integral?)
      (set! integral  (+ (* lastValue lastValuesDuration) integral))
      (set! integral (* lastValue lastValuesDuration)))
  (if (or (not (self 'min?)) 
          (<? aValue min)) (set! min aValue))
  (if (or (not (self 'max?)) 
          (>? aValue max)) (set! max aValue))
  (set! lastChange aTime)
  (set! lastValue  aValue))

(defMethod (reset! Accumulate) () 
  (set! lastChange 0) (set! lastValue 0) (set! obs 0) (set! integral 0) 
  (set! min 0) (set! max 0))

(defMethod (finalIntegral Accumulate) (aClockTime)
  (let ((finalIntegral nil))
    (if (self 'obs?)
        (begin ; flush out last observation
         (if (self 'integral?)
             (set! finalIntegral (+ (* lastValue (- aClockTime lastChange))
                                    integral))
             (set! finalIntegral (* lastValue (- aClockTime lastChange))) ))
        finalIntegral)))

(defMethod (mean Accumulate) (aClockTime)
  (if (not (or (zero? obs) (zero? aClockTime)))
      (/ (self 'finalIntegral aClockTIme) aClockTime)
      0))
  
(defMethod (show Accumulate) (aClockTime)
  (display "*** over ") (display aClockTime)
  (display " time units ") (display obs)
  (display " observations were made.") (newline)
  (display "    Mean: ") (display (self 'mean aClockTime)) (newline)
  (display "    Min : ") (display min) (newline)
  (display "    Max : ") (display max) (newline) )