; M.C. Stairmand, Nov. 1987.
; This is the biggy. The list ivars contains the ivars and initial values
; of flavour flavour. Meths contains the methods.


(define init (lambda ()
(set! ivars '((outofshape #f)
              (super ())
              (subs ())
              (name ())
              (mum ())
              (creator ())
              (self ())
              (getIVars #f)
              (setIVars #f)
              (testIVars #f)
              (localivars ())
              (methods ())
              (localmethods ())
              (env ())
              (envm ())
              (mlist (cons () 'gce))
              (ivars ())
              (newboy ())
              (everybody ())
              (tracing #f)
              (methods ())))


(set!
 meths
 '((addIvars (ivarlist)
              (for-each
               (lambda (ivar)
                 (if getIVars
                     (self 'addmethod ivar () (list ivar)))
                 (if setIVars
                    (self 'addmethod (string->symbol
                                       (string-append
                                        (symbol->string ivar)
                                        "!"))
                                      '(**sym**)
                                      (list
                                       (list 'set! ivar '**sym**))))
                 (if testIVars
                    (self 'addmethod (string->symbol
                                       (string-append
                                        (symbol->string ivar)
                                        "?"))
                                      ()
                                      (list
                                       (list 'if ivar #t #f))))
                 (if (member ivar localivars)
                     (set!
                      localivars (remove
                                   ivar
                                   localivars))))
               ivarlist)
              (for-each
               (lambda (ivar)
                 (if (member ivar ivars)
                     (set!
                      ivars (remove
                             ivar
                          ivars))))
               ivarlist)
              (set! localivars (append ivarlist localivars))
              (set! ivars (append ivarlist ivars))
              (set! outofshape #t)
              (for-each (lambda (x)
                          (x 'superaddivars ivarlist))
                        subs)
              #t)
   (superaddivars (ivarlist)
                    (for-each
                     (lambda (ivar)
                       (if (not (member ivar localivars))
                           (begin
                            (if (member ivar ivars)
                                (set!
                                 ivars (remove
                                        ivar
                                        ivars)))
                            (set! ivars (cons ivar ivars))
                            (for-each (lambda (x)
                                        (x 'superaddivars (list ivar)))
                                      subs))))
                     ivar-list))
   (getInstanceVars ()
                    (set! getIvars #t)
                    (for-each
                     (lambda (ivar)
                       (self 'addmethod ivar () (list ivar)))
                     localivars))
   (setInstanceVars ()
                    (set! setIvars #t)
                    (for-each
                     (lambda (ivar)
                       (self 'addmethod (string->symbol
                                         (string-append
                                          (symbol->string ivar)
                                          "!"))
                                        '(**sym**)
                                        (list
                                         (list 'set! ivar '**sym**))))
                     localivars))
    (testInstanceVars ()
                    (set! testIvars #t)
                    (for-each
                     (lambda (ivar)
                       (self 'addmethod (string->symbol
                                         (string-append
                                          (symbol->string ivar)
                                          "?"))
                                        ()
                                        (list
                                         (list 'if ivar #t #f))))
                     localivars))   
                         
                         
   (addsuper superflavours
           (set! outofshape #t)
           (for-each (lambda (fl)
                       (for-each
                        (lambda (ivar)
                          (if (not (member ivar ivars))
                          (set! ivars (append (list ivar)
                                              ivars))))
                          (fl 'ivars))
                       (for-each
                        (lambda (method)
                          (if (not (assq (car method) methods))
                              (set! methods (append (list method)
                                                    methods))))
                        (fl 'methods))
                       (if (not (memq fl super))
                           (set! super (append (list fl) super)))
                       (fl 'becomesub self))
                     superflavours))

   (becomesub (subflavour)
                (if (null? (subflavour 'name))
                        (begin
                         (disp name "refuses to become the super flavour of a nameless flavour")
                         (newline))
                        (begin
                         (for-each
                          (lambda (x)
                            (if (equal? (x 'name) (subflavour 'name))
                                (set! subs (remove x subs))))
                          subs)
                         (set! subs (append subs (list subflavour))))))
   (clearAKOlinks () (set! subs ()))
   (removeFlavour (flav) (set! subs (remove flav subs)))
   (removeMethod (meth)
                 (set! methods (remove
                                (assq meth methods)
                                methods))
                 (set!
                  localmethods (remove
                                (assq meth localmethods)
                                localmethods))
                 (set-car!
                  mlist (remove
                         (assq meth (car mlist))
                         (car mlist)))
                 (for-each
                  (lambda (sfl)
                    (let ((temp (assq meth (sfl 'methods))))
                      (if temp
                          (self 'superaddmethod (car temp)
                                                (cadr temp)
                                                (cddr temp)))))
                  super))
   (superaddmethod (name args body)
                     (if (not (assq name localmethods))
                         (begin
                          (if (assq name methods)
                              (set! methods (remove
                                             (assq name methods)
                                             methods)))
                          (set! methods
                                (append
                                 (list
                                  (append (list name args) body))
                                 methods))
                          (set-car!
                           mlist (remove
                                  (assq name (car mlist))
                                  (car mlist)))
                          (if (not outofshape)
                              (set-car! mlist (append
                                               (car mlist)
                                               (list
                                                (cons
                                                 name
                                                 (makemethod
                                                  env
                                                  (cons args body)))))))
                          (for-each
                           (lambda (subflav)
                             (subflav 'superaddmethod name args body))
                           subs))))
   (addmethod (name args body)
              (set!
               localmethods (remove
                             (assq name localmethods)
                             localmethods))
              (set!
               methods (remove
                        (assq name methods)
                        methods))
              (set-car!
               mlist (remove
                      (assq name (car mlist))
                      (car mlist)))
                    ; remove from mlist as well!
               (for-each
                (lambda (x)
                  (x 'superaddmethod name args body))
                subs)   
               (set!
                localmethods
                (append
                 (list
                  (append (list name args) body))
                 localmethods))
               (set! methods
                     (append
                      (list
                       (append (list name args) body))
                      methods))
               (if (not outofshape)
                   (set-car! mlist (append
                                    (car mlist)
                                    (list
                                     (cons
                                      name
                                      (makemethod
                                       env
                                       (cons args body)))))))
               #t)
   (addcmethod (name args body)
               (if (not (self 'actormixed))
                   (begin
                   (disp (self 'name) " cannot create coroutines!")
                   (newline)
                   (disp "Suggest you add actor flavour")
                   (newline))
                   (begin
  (set! body
         `((call/cc (lambda (cont)
                      (if (assq ',name **initstates**)
                          (set! **initstates** (remove
                                            (assq ',name **initstates**)
                                            **initstates**)))
                      (set! **initstates** (append **initstates**
                                               (list
                                                (list ',name
                                                        cont
                                                        'no-method))))
                      (set! **currentmethod** ',name)
                      ,@body
                      (if (assq ',name **initstates**)
                          (set! **initstates** (remove
                                            (assq ',name **initstates**)
                                            **initstates**)))
                      (set! **initstates** (append **initstates**
                                               (list
                                               (list ',name
                                                       cont
                                                       'no-method
                                                       #t))))
                      (cont #!null)
                      (cerror "Coroutine ran off end"
                              **currentmethod**)))))
  (self 'addmethod name args body))))
   
   (actormixed ()
               (if (equal? 'actor name)
                   #t
                   (let ((found ()))
                   (for-each
                    (lambda (x)
                      (if (x 'actormixed)
                          (set! found #t)))
                    super)
                     found)))
   (new args
        (set! args (car args))
       (let ((new-il
        (map
         (lambda (x)
           (if (assq x args)
               (list x (cadr (assq x args)))
               (list x ())))
         ivars)))
         (set! envm (m-e-m new-il))
         (set! env (envm)))
        (if outofshape
            (begin
             (disp "recompiling flavour " name)
             (newline)
             (set! everybody ())
             (set-car! mlist (mapcar (lambda (m)
                                       (cons (car m)
                                             (makemethod
                                              env
                                              (cdr m))))
                                     methods))
             
             (set! outofshape #f)))
        (if (not (assq '**self!** methods))
            (begin
             (disp "This flavour could use some vanilla!")
             (newline)
             (disp "Add vanilla and try again.") (newline))
            (begin
             (set! newboy (instantiate env mlist (gensym
                                                  (symbol->string name))))
             (if tracing
                 (set! everybody (cons newboy everybody)))
             (newboy '**self!** newboy)
             (newboy '**mum!** name)
             (newboy '**flavourPointer!** self)
             newboy)))
   (newFlavour args
        (set! args (car args))
       (let ((new-il
        (map
         (lambda (x)
           (if (assq x args)
               (list x (cadr (assq x args)))
               (list x ())))
         ivars)))
         (set! envm (m-e-m new-il))
         (set! env (envm)))
        (if outofshape
            (begin
             (disp "recompiling flavour " name)
             (newline)
             (set! everybody ())
             (set-car! mlist (mapcar (lambda (m)
                                       (cons (car m)
                                             (makemethod
                                              env
                                              (cdr m))))
                                     methods))
             
             (set! outofshape #f)))
        (if (not (assq '**self!** methods))
            (begin
             (disp "This flavour could use some vanilla!")
             (newline)
             (disp "Add vanilla and try again.") (newline))
            (begin
             (set! newboy (instantiate env mlist (gensym
                                                  (symbol->string name))))
             (if tracing
                 (set! everybody (cons newboy everybody)))
             (newboy '**self!** newboy)
             (newboy '**mum!** name)
             (newboy '**flavourPointer!** self)
             (newboy 'mlist! (cons () 'gce))
              newboy))) 
   (describe ()
             (disp "Instance variables of flavour " name ":")
             (newline)
             (do ((i ivars (cdr i)))
                 ((null? i) #t)
                 (if (not (and (>? (string-length (symbol->string 
                                                   (car i)))
                                   1)
                               (string=? "**" (substring (symbol->string
                                                          (car i))
                                                         0 2))))
                     (begin 
                      (disp (car i))
                      (newline))))
             (newline)
             (disp "Methods of flavour " name ":")
             (newline)
             (do ((i methods (cdr i)))
                 ((null? i) #t)
                 (if (not (and (>? (string-length (symbol->string 
                                                   (caar i)))
                                   1)
                               (string=? "**" (substring (symbol->string
                                                          (caar i))
                                                         0 2)))) 
                     (begin
                      (disp (caar i))
                      (newline)))))
   (rfamily (history)
             (do ((i history (cdr i)))
                 ((null? i) #t)
                 (disp (car i) "-"))
             (disp name)
             (newline)
             (for-each
              (lambda (x)
                 (x 'rfamily (append history (list name))))
              subs))
   (akotree () (self 'rfamily '()))                          
   (mlist! (m) (set! mlist m))
   (mlist () mlist)
   (methods! (m) (set! methods m))
   (methods () methods)           
   (env! (e) (set! env e))
   (ivars! (i) (set! ivars i))
   (ivars () ivars)
   (**self!** (s) (set! self s))
   (self () self)
   (name! (n) (set! name n))
   (name () name)
   (envm! (e) (set! envm e))
   (super! (s) (set! super s))
   (super () super)
   (**mum!** (m) (set! mum m))
   (rememberoffspring! () (set! tracing #t))
   (forgetoffspring! () (set! tracing #t))
   (recordoffspring? () tracing)
   (everybody! (e) (set! everybody e))
   (everybody () everybody)
   (flavour () mum)
   (flavourPointer () creator)
   (**flavourPointer!** (f) (set! creator f))         
   (allivars! (i) (set! allivars ivars))))
               ()))
  
(define bootf 
  (lambda ()
    (init)
    (set! flavour (bootstrap-flavour ivars meths))
    (flavour 'ivars! (map (lambda (x) (car x)) ivars))))
                                                
                                                            