;COSC 302 ASSIGNMENT #1 PART 1 - 'Warm up to Scheme' - 5 marks
;Written by Raymond Wilson in pure Scheme.

;The width in pixels between where characters are printed.
(SET! xsize 10)

;The depth in pixels between where characters are printed.
(SET! ysize 10)

;The maximum preferred distance a person from the street can have in 
;relation to other guests
(SET! max_random_distance 30)

;This is a large unhappiness which mingle minimises from.
(SET! maxunhap 100)

;The 9 relative positions to check when calculating the amount of
;unhappiness for someone
(SET! positions '((-1 -1) (0 -1) (1 -1) (-1 0) (0 0) (1 0) (-1 1) (0 1) (1 1)))

;Format of table data is table (lopleft_x topleft_y bottomright_x ;bottomright_y)
(SET! table '(10 5 20 10))

;This holds the dimensions of the room 32,22 because of the walls.
(SET! roomsize '(32 22))

;This is the room that the party is held in
(SET! room (make-array (car roomsize) (cadr roomsize)))

;This holds the distances of every point in the room from the table
(SET! table_distances (make-array (car roomsize) (cadr roomsize)))

;Set up the quest list - please excuse the pun.
(SET! guests '(artie bernie dennis millie penelope susan viola wally))

;Initroom sets up the room with the walls and table set up.
(define (initroom)
  (do ((x 0 (1+ x)))
      ((= x (car roomsize)))
      (do ((y 0 (1+ y)))
          ((= y (cadr roomsize)))
          (if (OR (= x 0) (= y 0) (= x (1- (car roomsize))) (= y (1- (cadr roomsize))))
              (array-set! room x y -1)
              (begin
               (array-set! table_distances x y -1)
               (if (AND (>=? x (car table)) (<=? x (caddr table)) (>=? y (cadr table)) (<=? y (cadddr table)))
                   (array-set! room x y -1)
                   (array-set! room x y 0)))))))

;This calculates all the distances of positions from the table.
;In this procedure I deliberately use the hypotnenuse as the distance 
;between two objects be it a point in the room and the table or between
;two people since if they were to move one unit diagonally then they would
;actually move sqrt(2) units towards/away from an object so using the
;hypotenuse method works.
(define (calc_table_distances)
  (do ((x 1 (1+ x)))
      ((= x (car table)))
      (do ((y (cadr table) (1+ y)))
          ((>? y (cadddr table)))
          (array-set! table_distances x y (- (car table) x))))
  (do ((x (1+ (caddr table)) (1+ x)))
      ((= x (car roomsize)))
      (do ((y (cadr table) (1+ y)))
          ((>? y (cadddr table)))
          (array-set! table_distances x y (- x (caddr table)))))
  (do ((y 1 (1+ y)))
      ((= y (cadr table)))
      (do ((x (car table) (1+ x)))
          ((>? x (caddr table)))
          (array-set! table_distances x y (- (cadr table) y))))
  (do ((y (1+ (cadddr table)) (1+ y)))
      ((= y (cadr roomsize)))
      (do ((x (car table) (1+ x)))
          ((>? x (caddr table)))
          (array-set! table_distances x y (- y (cadddr table)))))
  (do ((x 1 (1+ x)))
      ((= x (car table)))
      (do ((y 1 (1+ y)))
          ((= y (cadr table)))
          (array-set! table_distances x y (sqrt (+ (expt (- (car table) x) 2) (expt (- (cadr table) y) 2))))))
  (do ((x (1+ (caddr table)) (1+ x)))
      ((= x (car roomsize)))
      (do ((y 1 (1+ y)))
          ((= y (cadr table)))
          (array-set! table_distances x y (sqrt (+ (expt (- (car table) x) 2) (expt (- (cadr table) y) 2))))))
  (do ((x 1 (1+ x)))
      ((= x (car table)))
      (do ((y (1+ (cadddr table)) (1+ y)))
          ((= y (cadr roomsize)))
          (array-set! table_distances x y (sqrt (+ (expt (- (car table) x) 2) (expt (- (cadr table) y) 2))))))
  (do ((x (1+ (caddr table)) (1+ x)))
      ((= x (car roomsize)))
      (do ((y (1+ (cadddr table)) (1+ y)))
          ((= y (cadr roomsize)))
          (array-set! table_distances x y (sqrt (+ (expt (- (car table) x) 2) (expt (- (cadr table) y) 2)))))))

;This is the object guest of which all guests are made.  
(define (makeguest person symbol tabledist)
  
  ;These set up relevant variables that will be used by this guest.
  ;old_x, old_y are set to 1 just as an initialisation value that will
  ;not wipe out portions on the top left hand corner.
  (define me_x 0)
  (define me_y 0)
  (define old_x 0)
  (define old_y 0)
  (define distances '())
  (define me person)
  (define my_symb symbol)
  (define table_dist tabledist)
  
  ;Works out the amount of unhappiness for a giving location in the room
  (define (compute_unhappiness to_who move)
    (define their_pos ((eval to_who) 'where))
    (if (= (array-ref room (+ me_x (car move)) (+ me_y (cadr move))) 0)
        (begin
         (SET! tempry (sqrt (+ (expt (- (+ me_x (car move)) (car their_pos)) 2) (expt (- (+ me_y (cadr move)) (cadr their_pos)) 2))))
         (+ tempry (abs (- (array-ref table_distances me_x me_y) table_dist))))
        maxunhap))
  
  ;Allows this guest to mingle in the party. The value for unhappiness is
  ;set to maxunhap at start of this procedure because mingle will minimise
  ;the unhappiness of this particular person. maxunhap is a value that is 
  ;rather unlikely to be bettered by an unhappiness value.
  (define (mingle)
    (SET! unhappiness maxunhap)
    (do ((people guests (cdr people)))
        ((NULL? people))
        (do ((moves positions (cdr moves)))
            ((NULL? moves))          
            (SET! howunhappy (compute_unhappiness (car people) (car moves)))
            (if (<? howunhappy unhappiness)
                (begin
                 (SET! unhappiness howunhappy)
                 (SET! whereto (car moves))))))
    (SET! me_x (+ me_x (car whereto)))
    (SET! me_y (+ me_y (cadr whereto))))
  
  ;This returns a set of random coordinates to put somebody at
  (define (getrandom)
    (define lookx (random (car roomsize)))
    (define looky (random (cadr roomsize)))
    (if (EQ? (array-ref room lookx looky) -1)
        (SET! temp (getrandom))
        (list lookx looky)))
  
  ;This sets up the relevant properties of the guest when it is set up   
  (define (initialise)
    (display "Have random position 'R' or any other key to enter position for ")    
    (display me) 
    (display " ")
    (SET! decision (read))
    (newline)
    (if (OR (EQ? decision 'R) (EQ? decision 'r))
        (begin
         (SET! randomcoords (getrandom))
         (SET! me_x (car randomcoords))
         (SET! me_y (cadr randomcoords))
         (array-set! room (car randomcoords) (cadr randomcoords) -1))
        (begin
         (display "Enter ") 
         (display me)
         (display "'s x y coordinates : ")
         (SET! me_x (read))
         (display ", ")
         (SET! me_y (read))
         (array-set! room me_x me_y -1)
         (newline)))
    (SET! old_x me_x)
    (SET! old_y me_y)
    (display "Have random distances (someone off the street) 'S' or ")
    (display "enter distances <any other key> for ")
    (display me) 
    (display " ")
    (SET! decision (read))
    (newline)
    (if (OR (EQ? decision 'S) (EQ? decision 's))
        (do ((people guests (cdr people)))
            ((NULL? people))
            (if (EQ? (car people) me)
                (SET! distances (append distances '(0)))
                (SET! distances (append distances (list (1+ (random max_random_distance)))))))
        (do ((people guests (cdr people)))
            ((NULL? people))
            (if (not (EQ? (car people) me))
                (begin
                 (display "Enter ")
                 (display me)
                 (display "'s preferred distance from ")
                 (display (car people))
                 (display " ")
                 (SET! distance (read))
                 (newline) 
                 (SET! distances (append distances (list distance))))
                (SET! distances (append distances '(0)))))))
  
  ;Printme erases the character at the old position on the screen and 
  ;prints the character at the new position then sets the old position to
  ;the new position.
  (define (printme)
    (move-to (1+ (* old_x xsize)) (1+ (* old_y ysize)))
    (erase-rect (1+ (* old_x xsize)) (1+ (* (1- old_y) ysize)) (1+ (* (1+ old_x) xsize)) (1+ (* old_y ysize)))
    (array-set! room old_x old_y 0)
    (move-to (1+ (* me_x xsize)) (1+ (* me_y ysize)))
    (draw-char my_symb)
    (SET! old_x me_x)
    (SET! old_y me_y)
    (array-set! room me_x me_y -1))
  
  (define (dispatch message)
    (cond ((EQ? message 'mingle) (mingle))
          ((EQ? message 'where) (list me_x me_y))
          ((EQ? message 'print) (printme))
          (#t (display "I don't know how to ")
              (display message))))
  (begin
   (initialise)
   dispatch))

;This prints up the people in the room at the party for the first time.
(define (printfirst)
  (do ((people guests (cdr people)))
      ((NULL? people))
      ((eval (car people)) 'print)))

;This calculates the distances away from the table. It is on it's own on 
;this line so it does not heve to be executed every time we run a party.
(calc_table_distances)

;This runs the party
(define (party_party_boom_boom)
  (initroom)
  (start-graphics 'full)
  (frame-rect xsize 0 (1+ (* (car roomsize) xsize)) (1+ (* (cadr roomsize) ysize)))
  (invert-rect (1+ (* (car table) xsize)) (1+ (* (cadr table) ysize)) (* (caddr table) xsize) (* (cadddr table) ysize))
  (printfirst)
  (do ((anumber 0 (1+ anumber)))
      ((= anumber -1))
      (do ((people guests (cdr people)))
          ((NULL? people))  
          ((eval (car people)) 'print)
          ((eval (car people)) 'mingle)))
  (end-graphics))   

;This sets up the walls and table in the room array. Needs to be called 
;BEFORE any of the guests are set up and is called every time a new party
;is started
(initroom)

;These define all of the guests at the party.
(define artie (makeguest 'artie "A" 1))
(define bernie (makeguest 'bernie "B" 1))
(define dennis (makeguest 'dennis "D" 1))
(define millie (makeguest 'millie "M" 5))
(define penelope (makeguest 'penelope "P" 5))
(define susan (makeguest 'susan "S" 1))
(define viola (makeguest 'viola "V" 5))
(define wally (makeguest 'wally "W" 5))

;Get the party rolling.    
(party_party_boom_boom)
