/* Topolgy tuple format:
   { Topology, Nodes, MyNode, ToSelf, 
				   ToNode0, ..., ToNodeN-1 }
*/
#define TOPOLOGY	  0    /* Topology descriptor: {Type,Size} */
#define NODES		  1    /* Number of nodes in topology */
#define MY_NODE		  2    /* My location in topology */
#define TOPOLOGY_ID	  3    /* The unique id for this topology */
#define TO_SELF		  4    /* Stream to my local server */
#define NODE_CONNECTIONS  5    /* Tuple of streams to other nodes */ 
#define OTHER_CONNECTIONS 6    /* Tuple of other streams (parent and manager) */

#define VT_TUPLE_SIZE     7

#define DUMMY_VT_ARG {"unknown", -1, 0, 0},

#define SUBTOPOLOGY_TABLE_INCREMENT     2
#define SUBTOPOLOGY_REMAP_FN 		0
#define SUBTOPOLOGY_NODE_CONNECTIONS	1
#define SUBTOPOLOGY_OTHER_CONNECTIONS	2
#define SUBTOPOLOGY_NUM_CHILDREN	3

/*
 * Offsets into OTHER_CONNECTIONS tuple
 */
#define TO_PARENT     0
#define TO_MANAGER    1

