/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * sys_hash.c
 *
 * Foreign procedures used by sys.pcn
 */

#include "sys_internal.h"

/*
 * Produce a hash 'value' from the key string, 'key'.  The hash table
 * has 'n' buckets.
 */
void _p_sys_hash_key(n,key,value)
int_t *n;
char_t *key;
int_t *value;
{
    unsigned long y;
    int i;
    for (y = 0; i = (int)(*key++); )
    {
	y <<= 1;
	y += i;
    }
    *value = (int_t) (y % *n);
}
