/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * sys_find_subr.c
 *
 * Foreign procedures used by sys.pcn
 */

#include "sys_internal.h"

/*
 * Set 'idx' to be the position of the last occurance of 'substring'
 * in 'string'.
 */
void _p_sys_find_substring_reverse(string, substring, idx)
char_t *string;
char_t *substring;
int_t *idx;
{
    char *s;
    int sublen;

    sublen = strlen(substring);

    for (s = strrchr(string, *substring); s >= string; s--)
    {
	if (*s == *substring && strncmp(s, substring, sublen) == 0)
	{
	    *idx = (int_t) (s - string);
	    return;
	}
    }
    *idx = -1;
}
