/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * sys_dtos.c
 *
 * Foreign procedures used by sys.pcn
 */

#include "sys_internal.h"

/*
 * Convert double 'D' into string 'S'.
 */
void _p_sys_double_to_string(D, S)
double_t *D;
char_t *S;
{
    char_t *last_zero;
    sprintf(S, "%.20f", (double) *D);
    
    /* Remove all of the trailing zeros to shorten it up */
    for (last_zero = S + strlen(S) - 1; *last_zero == '0'; last_zero--)
	;
    if (*last_zero == '.')
	last_zero++;
    *(++last_zero) = '\0';
}

