/*
 * PCN System
 * Author:      Steve Tuecke
 *              Argonne National Laboratory
 *
 * Please see the DISCLAIMER file in the top level directory of the
 * distribution regarding the provisions under which this software
 * is distributed.
 *
 * stdio_sprintf.c
 */

#include "stdio_internal.h"


/*
 * If format string looks like "%d %f" this will
 * temporily change the format string to look like "%d".
 * Then call fprintf().  Then change the format string to
 * look like " %f".
 */
#define sprint_arg(c_type, pcn_type, cPtr, str, fmt, arg, status) \
{ \
    char __ch = *(++cPtr); \
    *cPtr = '\0'; \
    sprintf(str, fmt, (c_type) *((pcn_type *)(arg))); \
    status = strlen(str); \
    *cPtr = __ch; \
    fmt = cPtr; \
}


/*
 * _p_stdio_sprint_arg()
 *
 * Look for the '%' and the conversion character after it, in the 'fmt' 
 * If it is the same as the C then call fprintf().  Then change the
 * format string to the location after the conversion character
 */
void _p_stdio_sprint_arg(str, fmt, arg, arg_type, status, depth, chars_printed)
char_t *str;
struct s_fmt *fmt;
char_t *arg;
int_t *arg_type;
int_t *status;
int_t *depth, *chars_printed;	/* Used for term printing */
{
    int is_long = 0;
    int printed;
    char *fmt_ptr = fmt->string + fmt->findex;
    char *cPtr;
    
    *depth = 0;
    
    if ((cPtr = strchr(fmt_ptr, '%')) != NULL)
    {
	is_long = 0;
	printed = 0;
	while (!printed)
	{
	    switch (*(++cPtr))
	    {
	    case '%': 
		if ((cPtr = strchr(++cPtr, '%')) == NULL)
		    printed++;
	    case 'l': 
		is_long = 1;
		break;
	    case 'd':
	    case 'i':
	    {
		int_t dummy_i;
		if (*arg_type == ARG_TYPE_CHAR)
		    dummy_i = (int_t) *((char_t *) arg);
		else
		    dummy_i = *((int_t *) arg);
		
		if (is_long)
		    sprint_arg(long, int_t, cPtr, str, fmt_ptr,
			       &dummy_i, *status)
		else
		    sprint_arg(int, int_t, cPtr, str, fmt_ptr,
			       &dummy_i, *status);
		printed++;
		break;
	    }
	    case 'o':
	    case 'u':
	    case 'x':
	    case 'X':
	    {
		int_t dummy_i;
		if (*arg_type == ARG_TYPE_CHAR)
		    dummy_i = (int_t) *((char_t *) arg);
		else
		    dummy_i = *((int_t *) arg);
		
		if (is_long)
		    sprint_arg(unsigned long, u_int_t, cPtr, str, fmt_ptr,
			       &dummy_i, *status)
		else
		    sprint_arg(unsigned int, u_int_t, cPtr, str, fmt_ptr,
			       &dummy_i, *status);
		printed++;
		break;
	    }
	    case 'f':
	    case 'e':
	    case 'E':
	    case 'g':
	    case 'G':
		sprint_arg(double, double_t, cPtr, str, fmt_ptr, arg, *status);
		printed++;
		break;
	    case 'c':
	    {
		char_t dummy_c;
		if (*arg_type == ARG_TYPE_CHAR)
		    dummy_c = *((char_t *) arg);
		else
		    dummy_c = (char_t) *((int_t *) arg);
		sprint_arg(int, char_t, cPtr, str, fmt_ptr, &dummy_c, *status);
		printed++;
		break;
	    }
	    case 's':
		sprint_arg(char *, char_t *, cPtr, str, fmt_ptr, &arg,
			   *status);
		printed++;
		break;
	    case 't':
	    {
		char *cPtr1 = cPtr - 1;
		
		/* Null out the % */
		while (*cPtr1 != '%') cPtr1--;
		*cPtr1 = '\0'; 
		
		sprintf(str, fmt_ptr);
		
		/*
		if (*chars_printed = *status = strlen(str))
		    *status = is_long ? PRINT_LTERM : PRINT_TERM;
		*/
		*chars_printed = strlen(str);
		*status = is_long ? PRINT_LTERM : PRINT_TERM;
		
		fmt_ptr = cPtr+1;
		printed++;
		break;
	    }
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		*depth *= 10;
		*depth += *cPtr - '0';
		break;
	    default:
		break;
	    }
	}
	fmt->findex = fmt_ptr - fmt->string;
    }
    else
    {
	printf("WARNING: format string does not match arglist in sprintf\n");
	*status = 0;
    }
} /* _p_stdio_sprint_arg() */


void _p_stdio_sdump_fmt(str, fmt, status)
char_t *str;
struct s_fmt *fmt;
int_t *status;
{
    sprintf(str, fmt->string + fmt->findex);
    *status = strlen(str);
} /* _p_stdio_sdump_fmt() */
